/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.lib.plugins;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.querylang.functions.QueryFunction;
import com.atlassian.querylang.lib.plugins.BaseAQLModuleDescriptor;
import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import org.dom4j.Element;

@Scanned
public class AQLFunctionModuleDescriptor
extends BaseAQLModuleDescriptor<QueryFunction> {
    private Option<String> functionName;

    public AQLFunctionModuleDescriptor(@ComponentImport ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.functionName = Option.option((Object)element.attributeValue("functionName"));
    }

    @Override
    public void enabled() {
        super.enabled();
        this.overrideFunctionName();
    }

    private void overrideFunctionName() {
        QueryFunction function = (QueryFunction)this.getModule();
        try {
            if (this.functionName.isDefined()) {
                Field field = QueryFunction.class.getDeclaredField("name");
                field.setAccessible(true);
                field.set(function, this.functionName.get());
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

