import styled from '@emotion/styled';
import {
    Content,
    Description,
    Header,
    Icon,
    Title,
} from '@atlaskit/flag/components/Flag/styledFlag';
import { borderRadius, colors, elevation, gridSize } from '@atlaskit/theme';

export const MessageContainer = styled.section`
    background-color: ${colors.N0};
    border-radius: ${borderRadius}px;
    box-sizing: border-box;
    color: ${colors.N500};
    padding: ${gridSize() * 2}px;
    margin: ${gridSize() / 2}px 1px;
    ${elevation.e100};

    &:focus {
        outline: none;
        box-shadow: 0 0 0 2px ${colors.B100};
    }
`;

export { Content, Description, Header, Icon, Title };
