import React from 'react';

import formatter from 'shims/i18n';
import DeprecatedPlugins from 'health-checks/deprecated-plugins.ui';
import ConnectivityHealthChecks, { getConnectivityResults } from 'health-checks/health-checks.ui';
import { useCdnData } from 'admin-config/cdn-data-context';
import { HealthChecksContainer, MetricsContainer } from './performance-tab.styled';
import LatencyMetric from './latency-metric';

const AdminPerformanceTab = () => {
    const [cdnData] = useCdnData();

    return (
        <>
            <section>
                <MetricsContainer>
                    <LatencyMetric />
                </MetricsContainer>

                <HealthChecksContainer>
                    <h3>{formatter.I18n.getText('static.assets.admin.health.title')}</h3>
                    {cdnData && cdnData.enabled && (
                        <ConnectivityHealthChecks checks={getConnectivityResults(cdnData.url)} />
                    )}
                    <DeprecatedPlugins />
                </HealthChecksContainer>
            </section>
        </>
    );
};

export default AdminPerformanceTab;
