import React from 'react';
import PropTypes from 'prop-types';
import Button from '@atlaskit/button/components/Button';

import formatter from 'shims/i18n';

const LearnMore = ({ url }) => {
    return (
        <>
            <Button appearance="link" spacing="none" href={url}>
                {formatter.I18n.getText('static.assets.admin.learn.more')}
            </Button>
        </>
    );
};
LearnMore.propTypes = {
    url: PropTypes.string.isRequired,
};

export default LearnMore;
