import contextPath from 'wrm/context-path'; // eslint-disable-line
import CdnData from './cdn-data';

function mapServerResponseToCdnData(serverResponse) {
    if (!serverResponse || !('enabled' in serverResponse && 'url' in serverResponse)) {
        throw new Error('Malformed CDN data received');
    }
    return new CdnData(!!serverResponse.enabled, serverResponse.url ? serverResponse.url : '');
}

/**
 * @returns {Promise<CdnData>}
 */
export function getCdnSettings() {
    const url = `${contextPath()}/rest/static-asset-caching/configuration`;
    return fetch(url)
        .then(response => {
            if (response.ok) {
                return response.json();
            }
            throw new Error('Fetch failed');
        })
        .then(mapServerResponseToCdnData);
}

/**
 * @param {CdnData} newCdnData
 * @returns {Promise<CdnData>}
 */
export function saveCdnSettings(newCdnData) {
    const url = `${contextPath()}/rest/static-asset-caching/configuration`;
    return fetch(url, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(newCdnData),
    })
        .then(response => {
            if (response.ok) {
                return response.json();
            }
            throw new Error('Fetch failed');
        })
        .then(mapServerResponseToCdnData);
}
