import React from 'react';
import Tabs from '@atlaskit/tabs';

import formatter from 'shims/i18n';
import { CdnDataProvider } from 'admin-config/cdn-data-context';
import AdminPerformanceTab from 'admin-config/performance/performance-tab';
import AdminSettingsTab from 'admin-config/settings/settings-tab';
import CdnStatus from 'admin-config/cdn-status';
import { Container, TabsContainer } from './admin-config.styled';

const cdnDataInitialState = null;

const reducer = (state, action) => {
    switch (action.type) {
        case 'changeCdnData':
            return {
                ...state,
                ...action.cdnData,
            };

        default:
            return state;
    }
};

const tabs = [
    {
        label: formatter.I18n.getText('static.assets.admin.performance.tab.title'),
        content: <AdminPerformanceTab />,
    },
    {
        label: formatter.I18n.getText('static.assets.admin.settings.tab.title'),
        content: <AdminSettingsTab />,
    },
];

const AdminConfigPage = () => {
    return (
        <CdnDataProvider initialState={cdnDataInitialState} reducer={reducer}>
            <Container>
                <CdnStatus />
                <TabsContainer>
                    <Tabs tabs={tabs} />
                </TabsContainer>
            </Container>
        </CdnDataProvider>
    );
};

export default AdminConfigPage;
