import React, { useEffect } from 'react';
import Lozenge from '@atlaskit/lozenge';
import Spinner from '@atlaskit/spinner';

import formatter from 'shims/i18n';
import { warn } from 'shims/logger';
import { getCdnSettings } from 'admin-config/cdn-data-service';
import { useCdnData } from 'admin-config/cdn-data-context';
import { CdnStatusContainer } from './cdn-status.styled';

const CdnStatus = () => {
    const [initCdnData, dispatch] = useCdnData();

    useEffect(() => {
        getCdnSettings()
            .then(cdnData => {
                dispatch({ type: 'changeCdnData', cdnData });
            })
            .catch(err => {
                warn('Something went wrong when fetching cdn data', err);
            });
    }, []);

    return (
        <CdnStatusContainer>
            <span>{formatter.I18n.getText('static.assets.admin.cdn.status')}</span>
            {initCdnData ? (
                <Lozenge appearance={initCdnData.enabled ? 'success' : 'default'} isBold>
                    {initCdnData.enabled
                        ? formatter.I18n.getText('static.assets.admin.cdn.status.on')
                        : formatter.I18n.getText('static.assets.admin.cdn.status.off')}
                </Lozenge>
            ) : (
                <Spinner size="small" />
            )}
        </CdnStatusContainer>
    );
};

export default CdnStatus;
