/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.sal;

import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugins.rest.v2.exception.jersey.EntityConversionException;
import com.atlassian.plugins.rest.v2.scanner.AnnotatedClassScanner;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ResourceConfig;

public class MarshallingEntityHandler {
    private final MessageBodyFactory messageBodyFactory;

    public MarshallingEntityHandler(OsgiPlugin plugin) {
        this(new AnnotatedClassScanner(plugin.getBundle(), false, Provider.class).scan(Collections.emptySet()));
    }

    MarshallingEntityHandler(Set<Class<?>> providersScan) {
        ResourceConfig config = new ResourceConfig().register((Object)new MessageBodyWorkersBinder(providersScan));
        this.messageBodyFactory = new MessageBodyFactory(null);
        ApplicationHandler applicationHandler = new ApplicationHandler((Application)config);
        this.messageBodyFactory.initialize(applicationHandler.getInjectionManager());
    }

    public String marshall(Object entity, MediaType mediaType, Charset charset) throws IOException {
        Type entityType;
        if (entity instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)entity;
            entityType = genericEntity.getType();
            entity = genericEntity.getEntity();
        } else {
            entityType = entity.getClass();
        }
        Class<?> entityClass = entity.getClass();
        MessageBodyWriter messageBodyWriter = this.messageBodyFactory.getMessageBodyWriter(entityClass, entityType, new Annotation[0], mediaType);
        if (messageBodyWriter == null) {
            throw new RuntimeException("Unable to find a message body writer for " + String.valueOf(entityClass));
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        messageBodyWriter.writeTo(entity, entityClass, entityType, new Annotation[0], mediaType, (MultivaluedMap)new MultivaluedHashMap(), (OutputStream)outputStream);
        return outputStream.toString(charset.name());
    }

    public <T> T unmarshall(Class<T> entityClass, MediaType mediaType, InputStream entityStream, Map<String, List<String>> responseHeaders) throws IOException {
        MessageBodyReader reader = this.messageBodyFactory.getMessageBodyReader(entityClass, entityClass, new Annotation[0], mediaType);
        if (reader == null) {
            throw new RuntimeException("Unable to find a message body reader for " + String.valueOf(entityClass));
        }
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.putAll(responseHeaders);
        try {
            return (T)reader.readFrom(entityClass, entityClass, new Annotation[0], mediaType, (MultivaluedMap)headers, entityStream);
        }
        catch (IOException e) {
            throw new EntityConversionException(e);
        }
    }

    MessageBodyFactory getMessageBodyFactory() {
        return this.messageBodyFactory;
    }

    private static class MessageBodyWorkersBinder
    extends AbstractBinder {
        private final Set<Class<?>> providerClasses;

        public MessageBodyWorkersBinder(Set<Class<?>> providerClasses) {
            this.providerClasses = providerClasses;
        }

        protected void configure() {
            this.providerClasses.forEach(provider -> {
                if (MessageBodyWriter.class.isAssignableFrom((Class<?>)provider)) {
                    this.bind((Class)provider).to(MessageBodyWriter.class);
                } else if (MessageBodyReader.class.isAssignableFrom((Class<?>)provider)) {
                    this.bind((Class)provider).to(MessageBodyReader.class);
                }
            });
        }
    }
}

