/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.Validate;

public class ChainingClassLoader
extends ClassLoader {
    private final List<ClassLoader> classLoaders;

    public ChainingClassLoader(ClassLoader ... classLoaders) {
        Validate.noNullElements((Object[])classLoaders, (String)"ClassLoader arguments cannot be null", (Object[])new Object[0]);
        this.classLoaders = Arrays.asList(classLoaders);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader classloader : this.classLoaders) {
            try {
                return classloader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return new ResourcesEnumeration(name, this.classLoaders);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classloader : this.classLoaders) {
            URL url = classloader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classloader : this.classLoaders) {
            InputStream inputStream = classloader.getResourceAsStream(name);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    @Override
    public synchronized void setDefaultAssertionStatus(boolean enabled) {
        for (ClassLoader classloader : this.classLoaders) {
            classloader.setDefaultAssertionStatus(enabled);
        }
    }

    @Override
    public synchronized void setPackageAssertionStatus(String packageName, boolean enabled) {
        for (ClassLoader classloader : this.classLoaders) {
            classloader.setPackageAssertionStatus(packageName, enabled);
        }
    }

    @Override
    public synchronized void setClassAssertionStatus(String className, boolean enabled) {
        for (ClassLoader classloader : this.classLoaders) {
            classloader.setClassAssertionStatus(className, enabled);
        }
    }

    @Override
    public synchronized void clearAssertionStatus() {
        for (ClassLoader classloader : this.classLoaders) {
            classloader.clearAssertionStatus();
        }
    }

    private static final class ResourcesEnumeration
    implements Enumeration<URL> {
        private final List<Enumeration<URL>> resources;
        private final String resourceName;

        ResourcesEnumeration(String resourceName, List<ClassLoader> classLoaders) throws IOException {
            this.resourceName = resourceName;
            this.resources = new LinkedList<Enumeration<URL>>();
            for (ClassLoader classLoader : classLoaders) {
                this.resources.add(classLoader.getResources(resourceName));
            }
        }

        @Override
        public boolean hasMoreElements() {
            for (Enumeration<URL> resource : this.resources) {
                if (!resource.hasMoreElements()) continue;
                return true;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            for (Enumeration<URL> resource : this.resources) {
                if (!resource.hasMoreElements()) continue;
                return resource.nextElement();
            }
            throw new NoSuchElementException(this.resourceName);
        }
    }
}

