/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.multipart.jersey;

import com.atlassian.plugins.rest.api.multipart.MultipartConfig;
import com.atlassian.plugins.rest.api.multipart.MultipartConfigClass;
import com.atlassian.plugins.rest.api.multipart.MultipartForm;
import com.atlassian.plugins.rest.v2.multipart.fileupload.CommonsFileUploadMultipartHandler;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.commons.fileupload2.core.RequestContext;
import org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;

@Provider
@Consumes(value={"multipart/form-data"})
public class MultipartFormMessageBodyReader
implements MessageBodyReader<MultipartForm> {
    @Context
    private ResourceInfo resourceInfo;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(MultipartForm.class);
    }

    public MultipartForm readFrom(Class<MultipartForm> type, Type genericType, Annotation[] annotations, final MediaType mediaType, MultivaluedMap<String, String> httpHeaders, final InputStream entityStream) throws WebApplicationException {
        CommonsFileUploadMultipartHandler handler = this.getMultipartHandler();
        return handler.getForm(new RequestContext(){

            public String getCharacterEncoding() {
                return AbstractMessageReaderWriterProvider.getCharset((MediaType)mediaType).name();
            }

            public String getContentType() {
                return mediaType.toString();
            }

            public long getContentLength() {
                return -1L;
            }

            public InputStream getInputStream() {
                return entityStream;
            }
        });
    }

    private CommonsFileUploadMultipartHandler getMultipartHandler() {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.resourceInfo.getResourceMethod().getAnnotations()) {
            if (!(annotation instanceof MultipartConfigClass)) continue;
            Class configClass = ((MultipartConfigClass)annotation).value();
            try {
                MultipartConfig multipartConfig = (MultipartConfig)configClass.newInstance();
                return new CommonsFileUploadMultipartHandler(multipartConfig.getMaxFileSize(), multipartConfig.getMaxSize(), multipartConfig.getMaxFileCount());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return new CommonsFileUploadMultipartHandler();
    }
}

