/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.servlet;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.servlet.DefaultServletModuleManager;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletFilterModuleDescriptor;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.servlet.filter.FilterDispatcherCondition;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import com.atlassian.plugin.servlet.util.DefaultPathMapper;
import com.atlassian.plugin.servlet.util.PathMapper;
import com.atlassian.plugins.rest.v2.descriptor.RestServletFilterModuleDescriptor;
import com.atlassian.plugins.rest.v2.servlet.RestServletModuleManager;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Comparator;
import java.util.Optional;
import java.util.SortedSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestServletModuleManager
implements RestServletModuleManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRestServletModuleManager.class);
    private static final RestServletFilterModuleDescriptorComparator VALUE_COMPARATOR = new RestServletFilterModuleDescriptorComparator();
    public static final String REST_PATH = "/rest";
    private final SortedSetMultimap<String, RestServletFilterModuleDescriptor> filterModuleDescriptors = Multimaps.synchronizedSortedSetMultimap((SortedSetMultimap)TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)VALUE_COMPARATOR));
    private final ServletModuleManager delegateModuleManager;
    private final PathMapper filterPathMapper;
    private final String path;

    public DefaultRestServletModuleManager(PluginEventManager pluginEventManager) {
        this.filterPathMapper = new DefaultPathMapper();
        this.delegateModuleManager = new DefaultServletModuleManager(pluginEventManager, (PathMapper)new DefaultPathMapper(), this.filterPathMapper);
        this.path = REST_PATH;
    }

    DefaultRestServletModuleManager(ServletModuleManager delegate, PathMapper filterPathMapper) {
        this.filterPathMapper = filterPathMapper;
        this.delegateModuleManager = delegate;
        this.path = REST_PATH;
    }

    public void addServlet(Plugin plugin, String servletName, String className) {
        this.delegateModuleManager.addServlet(plugin, servletName, className);
    }

    public void addServlet(Plugin plugin, String servletName, HttpServlet servlet, ServletContext servletContext) {
        this.delegateModuleManager.addServlet(plugin, servletName, servlet, servletContext);
    }

    public void addServletModule(ServletModuleDescriptor descriptor) {
        this.delegateModuleManager.addServletModule(descriptor);
    }

    public HttpServlet getServlet(String path, ServletConfig servletConfig) throws ServletException {
        return this.delegateModuleManager.getServlet(path, servletConfig);
    }

    public void removeServletModule(ServletModuleDescriptor descriptor) {
        this.delegateModuleManager.removeServletModule(descriptor);
    }

    public void addFilterModule(ServletFilterModuleDescriptor descriptor) {
        if (descriptor instanceof RestServletFilterModuleDescriptor) {
            Optional<RestServletFilterModuleDescriptor> optionalDescriptorPath = this.findClashingDescriptorPath(descriptor);
            if (optionalDescriptorPath.isPresent()) {
                this.handleDescriptorPathClash(descriptor, optionalDescriptorPath.get());
                return;
            }
            this.updateRestFilterModuleDescriptor((RestServletFilterModuleDescriptor)descriptor);
        }
        this.delegateModuleManager.addFilterModule(descriptor);
    }

    private Optional<RestServletFilterModuleDescriptor> findClashingDescriptorPath(ServletFilterModuleDescriptor descriptor) {
        if (!(descriptor instanceof RestServletFilterModuleDescriptor)) {
            return Optional.empty();
        }
        RestServletFilterModuleDescriptor restDescriptor = (RestServletFilterModuleDescriptor)descriptor;
        return this.filterModuleDescriptors.get((Object)restDescriptor.getBasePath()).stream().filter(filterModuleDescriptor -> filterModuleDescriptor.getPaths().stream().anyMatch(restDescriptor.getPaths()::contains)).filter(filterModuleDescriptor -> !filterModuleDescriptor.getCompleteKey().equals(restDescriptor.getCompleteKey())).findFirst();
    }

    private void handleDescriptorPathClash(ServletFilterModuleDescriptor descriptor, RestServletFilterModuleDescriptor existingRestServletFilterModuleDescriptor) {
        LOG.warn("A clash exists for the path+version combination '{}'. The same combination is defined in another filter module descriptor: '{}'. Disabling the filter module '{}.", new Object[]{descriptor.getPaths().get(0), existingRestServletFilterModuleDescriptor.getCompleteKey(), descriptor.getCompleteKey()});
        descriptor.disabled();
    }

    private void updateRestFilterModuleDescriptor(RestServletFilterModuleDescriptor descriptor) {
        RestServletFilterModuleDescriptor latest = this.getRestServletFilterModuleDescriptorForLatest(descriptor.getBasePath());
        if (VALUE_COMPARATOR.compare(latest, descriptor) < 0) {
            this.updateLatestModuleDescriptor(latest);
            this.filterPathMapper.put(descriptor.getCompleteKey(), this.getLatestPathPattern(descriptor.getBasePath()));
        }
        this.filterModuleDescriptors.put((Object)descriptor.getBasePath(), (Object)descriptor);
    }

    private void updateLatestModuleDescriptor(RestServletFilterModuleDescriptor latest) {
        if (latest != null) {
            this.filterPathMapper.put(latest.getCompleteKey(), null);
            latest.getPaths().forEach(p -> this.filterPathMapper.put(latest.getCompleteKey(), p));
        }
    }

    private RestServletFilterModuleDescriptor getRestServletFilterModuleDescriptorForLatest(String path) {
        if (path == null) {
            return null;
        }
        SortedSet moduleDescriptors = this.filterModuleDescriptors.get((Object)path);
        return moduleDescriptors.isEmpty() ? null : (RestServletFilterModuleDescriptor)((Object)moduleDescriptors.last());
    }

    @Deprecated
    public Iterable<Filter> getFilters(FilterLocation location, String pathInfo, FilterConfig filterConfig, FilterDispatcherCondition filterDispatcherCondition) throws ServletException {
        return this.delegateModuleManager.getFilters(location, StringUtils.removeStart((String)pathInfo, (String)this.path), filterConfig, filterDispatcherCondition);
    }

    public Iterable<Filter> getFilters(FilterLocation location, String pathInfo, FilterConfig filterConfig, DispatcherType dispatcherType) {
        return this.delegateModuleManager.getFilters(location, StringUtils.removeStart((String)pathInfo, (String)this.path), filterConfig, dispatcherType);
    }

    public void removeFilterModule(ServletFilterModuleDescriptor descriptor) {
        if (descriptor instanceof RestServletFilterModuleDescriptor) {
            RestServletFilterModuleDescriptor restServletFilterModuleDescriptor = (RestServletFilterModuleDescriptor)descriptor;
            RestServletFilterModuleDescriptor latest = this.getRestServletFilterModuleDescriptorForLatest(restServletFilterModuleDescriptor.getBasePath());
            this.filterModuleDescriptors.get((Object)restServletFilterModuleDescriptor.getBasePath()).stream().filter(filterModuleDescriptor -> filterModuleDescriptor.getCompleteKey().equals(restServletFilterModuleDescriptor.getCompleteKey())).findFirst().ifPresent(servletFilterModuleDescriptor -> this.filterModuleDescriptors.remove((Object)servletFilterModuleDescriptor.getBasePath(), (Object)servletFilterModuleDescriptor));
            if (latest != null && latest.getCompleteKey().equals(descriptor.getCompleteKey()) && (latest = this.getRestServletFilterModuleDescriptorForLatest(restServletFilterModuleDescriptor.getBasePath())) != null) {
                this.filterPathMapper.put(latest.getCompleteKey(), this.getLatestPathPattern(latest.getBasePath()));
            }
        }
        this.delegateModuleManager.removeFilterModule(descriptor);
    }

    String getLatestPathPattern(String basePath) {
        return basePath + "/latest/*";
    }

    private static final class RestServletFilterModuleDescriptorComparator
    implements Comparator<RestServletFilterModuleDescriptor> {
        private RestServletFilterModuleDescriptorComparator() {
        }

        @Override
        public int compare(RestServletFilterModuleDescriptor descriptor1, RestServletFilterModuleDescriptor descriptor2) {
            if (descriptor1 == null) {
                return -1;
            }
            if (descriptor2 == null) {
                return 1;
            }
            return descriptor1.getVersion().compareTo(descriptor2.getVersion());
        }
    }
}

