/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.security.xsrf;

import com.atlassian.http.method.Methods;
import com.atlassian.http.mime.BrowserUtils;
import com.atlassian.http.mime.UserAgentUtil;
import com.atlassian.http.mime.UserAgentUtilImpl;
import com.atlassian.http.url.SameOrigin;
import com.atlassian.plugins.rest.api.internal.security.cors.CorsDefaults;
import com.atlassian.plugins.rest.api.internal.security.cors.CorsHeaders;
import com.atlassian.plugins.rest.api.security.exception.XsrfCheckFailedException;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.sal.api.xsrf.XsrfRequestValidator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.internal.guava.Cache;
import org.glassfish.jersey.internal.guava.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=2000)
@Provider
public class XsrfResourceFilter
implements ContainerRequestFilter {
    public static final String TOKEN_HEADER = "X-Atlassian-Token";
    public static final String NO_CHECK = "no-check";
    private static final Response.Status FAILURE_STATUS = Response.Status.FORBIDDEN;
    private static final Set<String> XSRFABLE_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain")));
    private static final Set<String> BROWSER_EXTENSION_ORIGINS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("chrome-extension", "safari-extension")));
    private static final Logger log = LoggerFactory.getLogger(XsrfResourceFilter.class);
    private static final Cache<String, Boolean> XSRF_NOT_ENFORCED_RESOURCE_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private HttpContext httpContext;
    private XsrfRequestValidator xsrfRequestValidator;
    private List<CorsDefaults> corsDefaults;

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void setXsrfRequestValidator(XsrfRequestValidator xsrfRequestValidator) {
        this.xsrfRequestValidator = xsrfRequestValidator;
    }

    public void setCorsDefaults(List<CorsDefaults> corsDefaults) {
        this.corsDefaults = corsDefaults;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.passesAllXsrfChecks(requestContext)) {
            return;
        }
        throw new XsrfCheckFailedException(FAILURE_STATUS);
    }

    private boolean passesAllXsrfChecks(ContainerRequestContext requestContext) {
        HttpServletRequest httpRequest = XsrfResourceFilter.getRequestOrNull(this.httpContext);
        String method = httpRequest != null && httpRequest.getMethod() != null ? httpRequest.getMethod() : requestContext.getMethod();
        boolean isMethodMutative = Methods.isMutative((String)method);
        boolean isPostRequest = this.isPostRequest(method);
        if (isMethodMutative && this.isLikelyToBeFromBrowser(requestContext)) {
            boolean passesOriginChecks = this.passesAdditionalBrowserChecks(requestContext);
            if (isPostRequest && !passesOriginChecks) {
                return false;
            }
            if (!isPostRequest) {
                if (!passesOriginChecks) {
                    this.logXsrfFailureButNotBeingEnforced(requestContext, log);
                }
                return true;
            }
        }
        if (this.isXsrfable(method, requestContext.getMediaType())) {
            boolean passes;
            boolean bl = passes = this.passesStandardXsrfChecks(httpRequest) || this.hasDeprecatedHeaderValue(requestContext);
            if (passes) {
                return true;
            }
            if (isMethodMutative && !isPostRequest) {
                this.logXsrfFailureButNotBeingEnforced(requestContext, log);
                return true;
            }
            log.warn("XSRF checks failed for request: {} , origin: {} , referrer: {}", new Object[]{requestContext.getUriInfo().getRequestUri().toString().contains("?") ? StringUtils.substringBefore((String)requestContext.getUriInfo().getRequestUri().toString(), (String)"?") : requestContext.getUriInfo().getRequestUri().toString(), requestContext.getHeaderString(CorsHeaders.ORIGIN.value()), XsrfResourceFilter.getSanitisedReferrer(requestContext)});
            return false;
        }
        return true;
    }

    public void logXsrfFailureButNotBeingEnforced(ContainerRequestContext requestContext, Logger logger) {
        String key = requestContext.getUriInfo().getPath();
        if (key != null && XSRF_NOT_ENFORCED_RESOURCE_CACHE.getIfPresent((Object)key) == null) {
            logger.warn("XSRF failure not being enforced for request: {} , origin: {} , referrer: {}, method: {}", new Object[]{requestContext.getUriInfo().getRequestUri().toString().contains("?") ? StringUtils.substringBefore((String)requestContext.getUriInfo().getRequestUri().toString(), (String)"?") : requestContext.getUriInfo().getRequestUri().toString(), requestContext.getHeaderString(CorsHeaders.ORIGIN.value()), XsrfResourceFilter.getSanitisedReferrer(requestContext), requestContext.getMethod()});
            XSRF_NOT_ENFORCED_RESOURCE_CACHE.put((Object)key, (Object)Boolean.TRUE);
        }
    }

    private boolean passesStandardXsrfChecks(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return false;
        }
        return this.xsrfRequestValidator.validateRequestPassesXsrfChecks(httpServletRequest);
    }

    private boolean isOriginABrowserExtension(String origin) {
        if (StringUtils.isEmpty((CharSequence)origin)) {
            return false;
        }
        try {
            URI originUri = new URI(origin);
            return BROWSER_EXTENSION_ORIGINS.contains(originUri.getScheme()) && !originUri.isOpaque();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    protected boolean passesAdditionalBrowserChecks(ContainerRequestContext requestContext) {
        URI uri;
        String origin = requestContext.getHeaderString(CorsHeaders.ORIGIN.value());
        String referrer = XsrfResourceFilter.getSanitisedReferrer(requestContext);
        if (this.isSameOrigin(referrer, uri = requestContext.getUriInfo().getRequestUri())) {
            return true;
        }
        if (this.isSameOrigin(origin, uri)) {
            return true;
        }
        if (this.isOriginABrowserExtension(origin)) {
            return true;
        }
        boolean requestContainsCredentials = XsrfResourceFilter.containsCredentials(requestContext);
        boolean requestAllowedViaCors = this.isAllowedViaCors(origin, requestContainsCredentials);
        if (requestAllowedViaCors) {
            return true;
        }
        if (requestContext.getMethod() != null && this.isPostRequest(requestContext.getMethod())) {
            log.warn("Additional XSRF checks failed for request: {} , origin: {} , referrer: {} , credentials in request: {} , allowed via CORS: {}", new Object[]{uri.toString().contains("?") ? StringUtils.substringBefore((String)uri.toString(), (String)"?") : uri.toString(), origin, referrer, requestContainsCredentials, requestAllowedViaCors});
        }
        return false;
    }

    boolean isXsrfable(String method, MediaType mediaType) {
        return mediaType != null && Methods.isMutative((String)method) && XSRFABLE_TYPES.contains(XsrfResourceFilter.mediaTypeToString(mediaType));
    }

    private boolean hasDeprecatedHeaderValue(ContainerRequestContext requestContext) {
        String tokenHeader = requestContext.getHeaderString(TOKEN_HEADER);
        if (tokenHeader == null) {
            return false;
        }
        String normalisedTokenHeader = tokenHeader.toLowerCase(Locale.ENGLISH);
        if (normalisedTokenHeader.equals("nocheck")) {
            log.warn("Use of the 'nocheck' value for {} has been deprecated since rest 3.0.0. Please use a value of 'no-check' instead.", (Object)TOKEN_HEADER);
            return true;
        }
        return false;
    }

    private boolean isSameOrigin(String uri, URI origin) {
        try {
            return StringUtils.isNotEmpty((CharSequence)uri) && SameOrigin.isSameOrigin((URI)new URI(uri), (URI)origin);
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    private boolean isAllowedViaCors(String originUri, boolean withCredentials) {
        if (originUri == null) {
            return false;
        }
        return this.corsDefaults.stream().anyMatch(delegate -> delegate.allowsOrigin(originUri) && (!withCredentials || delegate.allowsCredentials(originUri)));
    }

    private static boolean containsCredentials(ContainerRequestContext requestContext) {
        return XsrfResourceFilter.containsCookies(requestContext) || XsrfResourceFilter.containsHttpAuthHeader(requestContext);
    }

    private static boolean containsCookies(ContainerRequestContext requestContext) {
        return !requestContext.getCookies().isEmpty();
    }

    private static boolean containsHttpAuthHeader(ContainerRequestContext requestContext) {
        return StringUtils.isNotEmpty((CharSequence)requestContext.getHeaderString("Authorization"));
    }

    private boolean isPostRequest(String method) {
        return method.equals("POST");
    }

    private boolean isLikelyToBeFromBrowser(ContainerRequestContext requestContext) {
        String userAgent = requestContext.getHeaderString("User-Agent");
        UserAgentUtil.BrowserFamily browserFamily = new UserAgentUtilImpl().getBrowserFamily(userAgent);
        if ((this.passesStandardXsrfChecks(XsrfResourceFilter.getRequestOrNull(this.httpContext)) || this.hasDeprecatedHeaderValue(requestContext)) && BrowserUtils.isIE((String)userAgent)) {
            return false;
        }
        return !browserFamily.equals((Object)UserAgentUtil.BrowserFamily.UKNOWN);
    }

    private static HttpServletRequest getRequestOrNull(HttpContext httpContext) {
        return httpContext == null ? null : httpContext.getRequest();
    }

    private static String mediaTypeToString(MediaType mediaType) {
        return mediaType.getType().toLowerCase(Locale.ENGLISH) + "/" + mediaType.getSubtype().toLowerCase(Locale.ENGLISH);
    }

    private static String getSanitisedReferrer(ContainerRequestContext requestContext) {
        return StringUtils.substringBefore((String)requestContext.getHeaderString("Referer"), (String)"?");
    }
}

