/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.security.xsrf;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.plugins.rest.v2.security.cors.CorsDefaultService;
import com.atlassian.plugins.rest.v2.security.xsrf.XsrfResourceFilter;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.sal.api.xsrf.XsrfRequestValidator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Priority;
import javax.ws.rs.GET;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=2000)
@Provider
public class XsrfResourceDynamicFeature
implements DynamicFeature {
    private static final Logger log = LoggerFactory.getLogger(XsrfResourceDynamicFeature.class);
    private final HttpContext httpContext;
    private final XsrfRequestValidator xsrfRequestValidator;
    private final CorsDefaultService corsDefaultService;

    public XsrfResourceDynamicFeature(HttpContext httpContext, XsrfRequestValidator xsrfRequestValidator, CorsDefaultService corsDefaultService) {
        this.httpContext = Objects.requireNonNull(httpContext, "httpContext can't be null");
        this.xsrfRequestValidator = Objects.requireNonNull(xsrfRequestValidator, "xsrfRequestValidator can't be null");
        this.corsDefaultService = corsDefaultService;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Method method = resourceInfo.getResourceMethod();
        boolean hasExcludeAnnotation = XsrfResourceDynamicFeature.isXsrfProtectionExcludedAnnotationPresent(method.getAnnotations());
        XsrfResourceFilter xsrfResourceFilter = null;
        if (!method.isAnnotationPresent(GET.class) && !hasExcludeAnnotation) {
            xsrfResourceFilter = new XsrfResourceFilter();
        }
        if (xsrfResourceFilter != null) {
            xsrfResourceFilter.setHttpContext(this.httpContext);
            xsrfResourceFilter.setXsrfRequestValidator(this.xsrfRequestValidator);
            xsrfResourceFilter.setCorsDefaults(this.corsDefaultService.getCorsDefaults());
            context.register((Object)xsrfResourceFilter);
        }
    }

    private static boolean isXsrfProtectionExcludedAnnotationPresent(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getCanonicalName().equals(XsrfProtectionExcluded.class.getCanonicalName())) continue;
            if (!annotation.annotationType().equals(XsrfProtectionExcluded.class)) {
                log.warn("Detected usage of the com.atlassian.annotations.security. XsrfProtectionExcluded annotation loaded from elsewhere. {} != {}", (Object)XsrfProtectionExcluded.class.getClassLoader(), (Object)annotation.annotationType().getClassLoader());
            }
            return true;
        }
        return false;
    }
}

