/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.security.cors;

import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import com.atlassian.plugins.rest.v2.security.cors.CorsDefaultService;
import com.atlassian.plugins.rest.v2.security.cors.CorsResourceFilter;
import java.lang.annotation.Annotation;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
public class CorsResourceDynamicFeature
implements DynamicFeature {
    private final CorsDefaultService corsDefaultService;

    public CorsResourceDynamicFeature(CorsDefaultService corsDefaultService) {
        this.corsDefaultService = corsDefaultService;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        if (this.annotationIsPresent(resourceInfo)) {
            String targetMethod = "GET";
            for (Annotation annotation : resourceInfo.getResourceMethod().getAnnotations()) {
                HttpMethod httpMethod = annotation.annotationType().getAnnotation(HttpMethod.class);
                if (httpMethod == null) continue;
                targetMethod = httpMethod.value();
                break;
            }
            context.register((Object)new CorsResourceFilter(targetMethod, this.corsDefaultService));
        }
    }

    private boolean annotationIsPresent(ResourceInfo resourceInfo) {
        return resourceInfo.getResourceMethod().isAnnotationPresent(CorsAllowed.class) || resourceInfo.getResourceClass().isAnnotationPresent(CorsAllowed.class) || this.packageHasAnnotation(resourceInfo.getResourceClass().getPackage());
    }

    private boolean packageHasAnnotation(Package resourcePackage) {
        return resourcePackage != null && resourcePackage.isAnnotationPresent(CorsAllowed.class);
    }
}

