/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.sal;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugins.rest.v2.exception.jersey.EntityConversionException;
import com.atlassian.plugins.rest.v2.exception.jersey.UnsupportedContentTypeException;
import com.atlassian.plugins.rest.v2.sal.MarshallingEntityHandler;
import com.atlassian.plugins.rest.v2.sal.MarshallingResponse;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFilePart;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.MediaType;

public class MarshallingRequest
implements Request<MarshallingRequest, MarshallingResponse> {
    private final Request delegateRequest;
    private final MarshallingEntityHandler marshallingEntityHandler;
    private final Plugin plugin;
    private Object entity;

    public MarshallingRequest(Request delegateRequest, MarshallingEntityHandler marshallingEntityHandler, Plugin plugin) {
        this.delegateRequest = delegateRequest;
        this.marshallingEntityHandler = marshallingEntityHandler;
        this.plugin = plugin;
    }

    public MarshallingRequest addBasicAuthentication(String hostname, String username, String password) {
        this.delegateRequest.addBasicAuthentication(hostname, username, password);
        return this;
    }

    public MarshallingRequest setEntity(Object entity) {
        this.entity = Objects.requireNonNull(entity);
        return this;
    }

    public MarshallingRequest setConnectionTimeout(int i) {
        this.delegateRequest.setConnectionTimeout(i);
        return this;
    }

    public MarshallingRequest setSoTimeout(int i) {
        this.delegateRequest.setSoTimeout(i);
        return this;
    }

    public MarshallingRequest setUrl(String s) {
        this.delegateRequest.setUrl(s);
        return this;
    }

    public MarshallingRequest setRequestBody(String s) {
        this.delegateRequest.setRequestBody(s);
        return this;
    }

    public MarshallingRequest setRequestBody(String requestBody, String contentType) {
        this.delegateRequest.setRequestBody(requestBody, contentType);
        return this;
    }

    public MarshallingRequest setFiles(List<RequestFilePart> files) {
        this.delegateRequest.setFiles(files);
        return this;
    }

    public MarshallingRequest addRequestParameters(String ... strings) {
        this.delegateRequest.addRequestParameters(strings);
        return this;
    }

    public MarshallingRequest addHeader(String s, String s1) {
        this.delegateRequest.addHeader(s, s1);
        return this;
    }

    public MarshallingRequest setHeader(String s, String s1) {
        this.delegateRequest.setHeader(s, s1);
        return this;
    }

    public MarshallingRequest setFollowRedirects(boolean follow) {
        this.delegateRequest.setFollowRedirects(follow);
        return this;
    }

    public Map<String, List<String>> getHeaders() {
        return this.delegateRequest.getHeaders();
    }

    public void execute(ResponseHandler<? super MarshallingResponse> responseHandler) throws ResponseException {
        this.executeAndReturn(marshallingResponse -> {
            responseHandler.handle(marshallingResponse);
            return null;
        });
    }

    public String execute() throws ResponseException {
        this.marshallEntity();
        return this.delegateRequest.execute();
    }

    public <RET> RET executeAndReturn(ReturningResponseHandler<? super MarshallingResponse, RET> responseHandler) throws ResponseException {
        this.marshallEntity();
        Object result = this.delegateRequest.executeAndReturn(response -> {
            MarshallingResponse res = new MarshallingResponse(response, this.marshallingEntityHandler, this.plugin);
            return responseHandler.handle((Response)res);
        });
        return (RET)result;
    }

    private void marshallEntity() {
        if (this.entity != null) {
            MediaType type;
            String contentType = this.getOrSetSingleHeaderValue("Content-Type", "application/xml");
            this.getOrSetSingleHeaderValue("Accept", contentType);
            Charset charset = StandardCharsets.UTF_8;
            try {
                type = MediaType.valueOf((String)contentType);
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedContentTypeException(e.getMessage(), e);
            }
            try {
                String body = this.marshallingEntityHandler.marshall(this.entity, type, charset);
                this.setRequestBody(body, contentType);
            }
            catch (IOException e) {
                throw new EntityConversionException(e);
            }
        }
    }

    private String getOrSetSingleHeaderValue(String headerName, String defaultValue) {
        String value = defaultValue;
        List<String> headers = this.getHeaders().get(headerName);
        if (headers != null && !headers.isEmpty()) {
            if (headers.size() == 1) {
                value = headers.get(0);
            }
        } else {
            this.setHeader(headerName, defaultValue);
        }
        return value;
    }
}

