/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.expand.resolver;

import com.atlassian.plugins.rest.api.expand.EntityCrawler;
import com.atlassian.plugins.rest.api.expand.ExpandContext;
import com.atlassian.plugins.rest.api.expand.annotation.IndexedExpand;
import com.atlassian.plugins.rest.api.expand.expander.EntityExpander;
import com.atlassian.plugins.rest.api.expand.parameter.Indexes;
import com.atlassian.plugins.rest.api.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.api.internal.expand.exception.ExpandIndexException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

public class IndexedEntityExpanderResolver
implements EntityExpanderResolver {
    public boolean hasExpander(Class<?> type) {
        return this.getConstrainMethod(Objects.requireNonNull(type)) != null;
    }

    public <T> EntityExpander<T> getExpander(Class<? extends T> type) {
        Method method = this.getConstrainMethod(Objects.requireNonNull(type));
        return method != null ? new IndexedExpandEntityExpander(method) : null;
    }

    private <T> Method getConstrainMethod(Class<? extends T> type) {
        for (Method method : type.getDeclaredMethods()) {
            if (method.getAnnotation(IndexedExpand.class) == null || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(Indexes.class)) continue;
            return method;
        }
        return null;
    }

    private static class IndexedExpandEntityExpander
    implements EntityExpander<Object> {
        private final Method method;

        public IndexedExpandEntityExpander(Method method) {
            this.method = Objects.requireNonNull(method);
        }

        public Object expand(ExpandContext<Object> context, EntityExpanderResolver expanderResolver, EntityCrawler entityCrawler) {
            Object entity = context.getEntity();
            try {
                this.method.invoke(entity, context.getEntityExpandParameter().getIndexes(context.getExpandable()));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ExpandIndexException((Throwable)e);
            }
            entityCrawler.crawl(entity, context.getEntityExpandParameter().getExpandParameter(context.getExpandable()), expanderResolver);
            return entity;
        }
    }
}

