/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.darkfeature;

import com.atlassian.plugins.rest.api.darkfeature.RequiresDarkFeature;
import com.atlassian.plugins.rest.v2.darkfeature.DarkFeatureResourceFilter;
import com.atlassian.plugins.rest.v2.util.ReflectionUtils;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Priority;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=2000)
@Provider
public class DarkFeatureResourceDynamicFeature
implements DynamicFeature {
    private static final Logger log = LoggerFactory.getLogger(DarkFeatureResourceDynamicFeature.class);
    private final DarkFeatureManager darkFeatureManager;

    public DarkFeatureResourceDynamicFeature(@Nonnull DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager);
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        if (ReflectionUtils.getAnnotation(RequiresDarkFeature.class, resourceInfo.getResourceMethod()) != null || ReflectionUtils.getAnnotation(RequiresDarkFeature.class, resourceInfo.getResourceClass()) != null) {
            log.debug("RequiresDarkFeature annotation found - creating filter");
            context.register((Object)new DarkFeatureResourceFilter(resourceInfo, this.darkFeatureManager));
            return;
        }
        log.debug("No RequiresDarkFeature annotation found - not creating filter");
    }
}

