/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.api.model;

import com.atlassian.plugins.rest.api.model.Link;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Status {
    @XmlElement
    private final Plugin plugin;
    @XmlElement(name="status-code")
    private final Integer code;
    @XmlElement(name="sub-code")
    private final Integer subCode;
    @XmlElement
    private final String message;
    @XmlElement(name="etag")
    private final String eTag;
    @XmlElementWrapper(name="resources-created")
    @XmlElement(name="link")
    @JsonProperty(value="resources-created")
    private final Collection<Link> resourcesCreated;
    @XmlElementWrapper(name="resources-updated")
    @XmlElement(name="link")
    @JsonProperty(value="resources-updated")
    private final Collection<Link> resourcesUpdated;
    private static final List<Variant> POSSIBLE_VARIANTS = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE}).add().build();

    private Status() {
        this.plugin = null;
        this.code = -1;
        this.subCode = -1;
        this.message = null;
        this.eTag = null;
        this.resourcesCreated = null;
        this.resourcesUpdated = null;
    }

    private Status(Plugin plugin, Integer code, Integer subCode, String message, String eTag, Collection<Link> resourcesCreated, Collection<Link> resourcesUpdated) {
        this.plugin = plugin;
        this.code = code;
        this.subCode = subCode;
        this.message = message;
        this.eTag = eTag;
        this.resourcesCreated = resourcesCreated;
        this.resourcesUpdated = resourcesUpdated;
    }

    public static StatusResponseBuilder fromStatusCode(int statusCode) {
        return new StatusResponseBuilder(Response.Status.fromStatusCode((int)statusCode));
    }

    public static StatusResponseBuilder ok() {
        return new StatusResponseBuilder(Response.Status.OK);
    }

    public static StatusResponseBuilder notFound() {
        return new StatusResponseBuilder(Response.Status.NOT_FOUND);
    }

    public static StatusResponseBuilder error() {
        return new StatusResponseBuilder(Response.Status.INTERNAL_SERVER_ERROR).noCache().noStore();
    }

    public static StatusResponseBuilder badRequest() {
        return new StatusResponseBuilder(Response.Status.BAD_REQUEST).noCache().noStore();
    }

    public static StatusResponseBuilder forbidden() {
        return new StatusResponseBuilder(Response.Status.FORBIDDEN);
    }

    public static StatusResponseBuilder unauthorized() {
        return new StatusResponseBuilder(Response.Status.UNAUTHORIZED);
    }

    public static StatusResponseBuilder created(Link link) {
        return new StatusResponseBuilder(Response.Status.CREATED).created(Objects.requireNonNull(link));
    }

    public static StatusResponseBuilder conflict() {
        return new StatusResponseBuilder(Response.Status.CONFLICT);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public int getCode() {
        if (this.code != null) {
            return this.code;
        }
        return -1;
    }

    public int getSubCode() {
        if (this.subCode != null) {
            return this.subCode;
        }
        return -1;
    }

    public String getMessage() {
        return this.message;
    }

    public String getETag() {
        return this.eTag;
    }

    public Collection<Link> getResourcesCreated() {
        if (this.resourcesCreated == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.resourcesCreated);
    }

    public Collection<Link> getResourcesUpdated() {
        if (this.resourcesUpdated == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.resourcesUpdated);
    }

    public static MediaType variantFor(Request request) {
        Variant v = request.selectVariant(POSSIBLE_VARIANTS);
        if (v == null) {
            v = POSSIBLE_VARIANTS.get(0);
        }
        return v.getMediaType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Status status = (Status)o;
        return Objects.equals(this.plugin, status.plugin) && Objects.equals(this.code, status.code) && Objects.equals(this.subCode, status.subCode) && Objects.equals(this.message, status.message) && Objects.equals(this.eTag, status.eTag) && Objects.equals(this.resourcesCreated, status.resourcesCreated) && Objects.equals(this.resourcesUpdated, status.resourcesUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.plugin, this.code, this.subCode, this.message, this.eTag, this.resourcesCreated, this.resourcesUpdated);
    }

    public String toString() {
        return "Status{plugin=" + this.plugin + ", code=" + this.code + ", subCode=" + this.subCode + ", message='" + this.message + "', eTag='" + this.eTag + "', resourcesCreated=" + this.resourcesCreated + ", resourcesUpdated=" + this.resourcesUpdated + "}";
    }

    @XmlRootElement
    public static class Plugin {
        @XmlAttribute
        private final String key;
        @XmlAttribute
        private final String version;

        private Plugin() {
            this.key = null;
            this.version = null;
        }

        public Plugin(String key, String version) {
            this.key = Objects.requireNonNull(key, "key can't be null");
            this.version = Objects.requireNonNull(version, "version can't be null");
        }

        public String getKey() {
            return this.key;
        }

        public String getVersion() {
            return this.version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Plugin other = (Plugin)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.version == null) {
                return other.version == null;
            }
            return this.version.equals(other.version);
        }
    }

    public static class StatusResponseBuilder {
        private final CacheControl cacheControl;
        private final Response.Status status;
        private String eTag;
        private Plugin plugin;
        private String message;
        private List<Link> created;
        private List<Link> updated;

        private StatusResponseBuilder(Response.Status status) {
            this(status, new CacheControl());
        }

        private StatusResponseBuilder(Response.Status status, CacheControl cacheControl) {
            this.status = Objects.requireNonNull(status, "status can't be null");
            this.cacheControl = Objects.requireNonNull(cacheControl, "cacheControl can't be null");
        }

        public StatusResponseBuilder plugin(String key, String version) {
            this.plugin = new Plugin(key, version);
            return this;
        }

        public StatusResponseBuilder message(String message) {
            this.message = message;
            return this;
        }

        public StatusResponseBuilder tag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public StatusResponseBuilder noCache() {
            this.cacheControl.setNoCache(true);
            return this;
        }

        public StatusResponseBuilder noStore() {
            this.cacheControl.setNoStore(true);
            return this;
        }

        public Status build() {
            return new Status(this.plugin, this.status.getStatusCode(), null, this.message, this.eTag, this.created, this.updated);
        }

        public Response response() {
            return this.responseBuilder().build();
        }

        public Response.ResponseBuilder responseBuilder() {
            Response.ResponseBuilder builder = Response.status((Response.Status)this.status).cacheControl(this.cacheControl).tag(this.eTag).entity((Object)this.build()).type("application/xml");
            List<Link> c = this.getCreated();
            List<Link> u = this.getUpdated();
            if (c.size() == 1 && u.isEmpty()) {
                builder.location(c.get(0).getHref());
            } else if (u.size() == 1 && c.isEmpty()) {
                builder.location(u.get(0).getHref());
            }
            return builder;
        }

        public StatusResponseBuilder created(Link link) {
            this.getCreated().add(link);
            return this;
        }

        public StatusResponseBuilder updated(Link link) {
            this.getUpdated().add(link);
            return this;
        }

        private List<Link> getCreated() {
            if (this.created == null) {
                this.created = new LinkedList<Link>();
            }
            return this.created;
        }

        private List<Link> getUpdated() {
            if (this.updated == null) {
                this.updated = new LinkedList<Link>();
            }
            return this.updated;
        }
    }
}

