/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.module.template;

import com.atlassian.plugins.rest.common.template.Renderer;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sun.jersey.api.core.HttpContext;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendererImpl
implements Renderer {
    private final TemplateRenderer templateRenderer;
    private final OutputStreamWriter writer;
    private final HttpContext httpContext;
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;

    RendererImpl(TemplateRenderer templateRenderer, OutputStreamWriter writer, HttpContext httpContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer);
        this.writer = (OutputStreamWriter)Preconditions.checkNotNull((Object)writer);
        this.httpContext = (HttpContext)Preconditions.checkNotNull((Object)httpContext);
        this.httpServletRequest = httpServletRequest;
        this.httpServletResponse = httpServletResponse;
    }

    @Override
    public void render(Object model, String template) throws IOException {
        HashMap context = Maps.newHashMap();
        context.put("it", model);
        context.put("renderer", this);
        context.put("httpContext", this.httpContext);
        context.put("request", this.httpServletRequest);
        context.put("response", this.httpServletResponse);
        this.templateRenderer.render(this.getAbsolutePath(model.getClass(), template), (Map)context, (Writer)this.writer);
    }

    private String getAbsolutePath(Class<?> resourceClass, String path) {
        if (StringUtils.startsWith((String)path, (String)"/")) {
            return path;
        }
        if (StringUtils.isEmpty((String)path) || StringUtils.equals((String)path, (String)"/")) {
            path = "index";
        }
        return this.getAbsolutePath(resourceClass) + '/' + path;
    }

    private String getAbsolutePath(Class<?> resourceClass) {
        return '/' + resourceClass.getName().replace('.', '/').replace('$', '/');
    }
}

