/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.module;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugins.rest.common.expand.SelfExpandingExpander;
import com.atlassian.plugins.rest.common.expand.interceptor.ExpandInterceptor;
import com.atlassian.plugins.rest.common.expand.resolver.ChainingEntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.CollectionEntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.ExpandConstraintEntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.IdentityEntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.ListWrapperEntityExpanderResolver;
import com.atlassian.plugins.rest.common.filter.ExtensionJerseyFilter;
import com.atlassian.plugins.rest.common.interceptor.impl.InterceptorChainBuilderProvider;
import com.atlassian.plugins.rest.common.security.jersey.AntiSniffingResponseFilter;
import com.atlassian.plugins.rest.module.OsgiFactory;
import com.atlassian.plugins.rest.module.OsgiResourceConfig;
import com.atlassian.plugins.rest.module.OsgiServiceAccessor;
import com.atlassian.plugins.rest.module.OsgiServiceReferenceResourceFilterFactory;
import com.atlassian.plugins.rest.module.expand.resolver.PluginEntityExpanderResolver;
import com.atlassian.plugins.rest.module.filter.AcceptHeaderJerseyMvcFilter;
import com.atlassian.plugins.rest.module.filter.CorsAcceptOptionsPreflightFilter;
import com.atlassian.plugins.rest.module.json.JsonWithPaddingResponseFilter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import com.sun.jersey.spi.container.ResourceMethodDispatchProvider;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.sun.jersey.spi.template.TemplateProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ext.MessageBodyReader;
import org.codehaus.jackson.map.Module;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceConfigManager {
    private final OsgiServiceAccessor<ResourceFilterFactory> resourceFilterFactories;
    private final OsgiServiceAccessor<InjectableProvider> injectableProviders;
    private final OsgiServiceAccessor<TemplateProcessor> templateProcessors;
    private final OsgiServiceAccessor<MessageBodyReader> messageBodyReaders;
    private final OsgiServiceAccessor<ResourceMethodDispatchProvider> dispatchProviders;
    private final OsgiServiceAccessor<Module> modules;
    private final AutowireCapablePlugin plugin;
    private final Bundle bundle;

    public ResourceConfigManager(AutowireCapablePlugin plugin, Bundle bundle) {
        this.plugin = plugin;
        this.bundle = bundle;
        BundleContext bundleContext = bundle.getBundleContext();
        this.resourceFilterFactories = new OsgiServiceAccessor<ResourceFilterFactory>(ResourceFilterFactory.class, bundleContext, new OsgiFactory<ResourceFilterFactory>(){

            @Override
            public ResourceFilterFactory getInstance(BundleContext bundleContext, ServiceReference serviceReference) {
                return new OsgiServiceReferenceResourceFilterFactory(bundleContext, serviceReference);
            }
        });
        this.injectableProviders = new OsgiServiceAccessor<InjectableProvider>(InjectableProvider.class, bundleContext, new OsgiFactory<InjectableProvider>(){

            @Override
            public InjectableProvider getInstance(BundleContext bundleContext, ServiceReference serviceReference) {
                return (InjectableProvider)bundleContext.getService(serviceReference);
            }
        });
        this.templateProcessors = new OsgiServiceAccessor<TemplateProcessor>(TemplateProcessor.class, bundleContext, new OsgiFactory<TemplateProcessor>(){

            @Override
            public TemplateProcessor getInstance(BundleContext bundleContext, ServiceReference serviceReference) {
                return (TemplateProcessor)bundleContext.getService(serviceReference);
            }
        });
        this.messageBodyReaders = new OsgiServiceAccessor<MessageBodyReader>(MessageBodyReader.class, bundleContext, new OsgiFactory<MessageBodyReader>(){

            @Override
            public MessageBodyReader getInstance(BundleContext bundleContext, ServiceReference serviceReference) {
                return (MessageBodyReader)bundleContext.getService(serviceReference);
            }
        });
        this.dispatchProviders = new OsgiServiceAccessor<ResourceMethodDispatchProvider>(ResourceMethodDispatchProvider.class, bundleContext, new OsgiFactory<ResourceMethodDispatchProvider>(){

            @Override
            public ResourceMethodDispatchProvider getInstance(BundleContext bundleContext, ServiceReference serviceReference) {
                return (ResourceMethodDispatchProvider)bundleContext.getService(serviceReference);
            }
        });
        this.modules = new OsgiServiceAccessor<Module>(Module.class, bundleContext, new OsgiFactory<Module>(){

            @Override
            public Module getInstance(BundleContext bundleContext, ServiceReference serviceReference) {
                return (Module)bundleContext.getService(serviceReference);
            }
        });
    }

    public ResourceConfig createResourceConfig(Map<String, Object> props, String[] excludes, Set<String> packages) {
        List<String> excludesCollection = excludes != null ? Arrays.asList(excludes) : Collections.emptyList();
        ChainingEntityExpanderResolver expanderResolver = new ChainingEntityExpanderResolver(Lists.newArrayList((Object[])new EntityExpanderResolver[]{new PluginEntityExpanderResolver(this.plugin), new CollectionEntityExpanderResolver(), new ListWrapperEntityExpanderResolver(), new ExpandConstraintEntityExpanderResolver(), new SelfExpandingExpander.Resolver(), new IdentityEntityExpanderResolver()}));
        LinkedList providers = Lists.newLinkedList();
        providers.addAll(this.injectableProviders.get());
        providers.addAll(this.templateProcessors.get());
        providers.addAll(this.messageBodyReaders.get());
        providers.addAll(this.dispatchProviders.get());
        providers.add(new InterceptorChainBuilderProvider(this.plugin, new ExpandInterceptor(expanderResolver)));
        ArrayList containerRequestFilters = Lists.newArrayList((Object[])new ContainerRequestFilter[]{new ExtensionJerseyFilter(excludesCollection), new AcceptHeaderJerseyMvcFilter(), new CorsAcceptOptionsPreflightFilter()});
        ImmutableList.Builder containerResponseFilters = new ImmutableList.Builder();
        containerResponseFilters.add((Object)new AntiSniffingResponseFilter());
        if ("true".equals(System.getProperty("atlassian.allow.jsonp"))) {
            containerResponseFilters.add((Object)new JsonWithPaddingResponseFilter());
        }
        return new OsgiResourceConfig(this.bundle, packages, containerRequestFilters, (Collection<? extends ContainerResponseFilter>)containerResponseFilters.build(), this.resourceFilterFactories.get(), this.modules.get(), providers);
    }

    public void destroy() {
        this.resourceFilterFactories.release();
        this.injectableProviders.release();
        this.templateProcessors.release();
        this.messageBodyReaders.release();
        this.dispatchProviders.release();
        this.modules.release();
    }
}

