/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.module;

import com.atlassian.plugins.rest.module.InvalidVersionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiVersion
implements Comparable {
    public static final String NONE_STRING = "none";
    public static final ApiVersion NONE = new ApiVersion("none");
    private static final String DOT = ".";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.([\\w-]*))?");
    private final Integer major;
    private final Integer minor;
    private final Integer micro;
    private final String classifier;

    public ApiVersion(String version) {
        if (version == null) {
            throw new InvalidVersionException(version);
        }
        if (NONE_STRING.equals(version)) {
            this.micro = null;
            this.minor = null;
            this.major = null;
            this.classifier = null;
        } else {
            Matcher matcher = VERSION_PATTERN.matcher(version);
            if (!matcher.matches()) {
                throw new InvalidVersionException(version);
            }
            this.major = Integer.valueOf(matcher.group(1));
            this.minor = matcher.group(2) != null ? Integer.valueOf(matcher.group(2)) : null;
            this.micro = matcher.group(3) != null ? Integer.valueOf(matcher.group(3)) : null;
            this.classifier = matcher.group(4);
        }
    }

    boolean isNone() {
        return this.equals(NONE);
    }

    static boolean isNone(String version) {
        return NONE_STRING.equals(version);
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getMicro() {
        return this.micro;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ApiVersion version = (ApiVersion)o;
        return new EqualsBuilder().append((Object)this.major, (Object)version.major).append((Object)this.minor, (Object)version.minor).append((Object)this.micro, (Object)version.micro).append((Object)this.classifier, (Object)version.classifier).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 41).append((Object)this.major).append((Object)this.minor).append((Object)this.micro).append((Object)this.classifier).toHashCode();
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        if (o.getClass() != this.getClass()) {
            return 1;
        }
        ApiVersion that = (ApiVersion)o;
        int majorDifference = this.compare(this.major, that.major);
        if (majorDifference != 0) {
            return majorDifference;
        }
        int minorDifference = this.compare(this.minor, that.minor);
        if (minorDifference != 0) {
            return minorDifference;
        }
        int microDifference = this.compare(this.micro, that.micro);
        if (microDifference != 0) {
            return microDifference;
        }
        return this.compare(this.classifier, that.classifier);
    }

    private <T extends Comparable<T>> int compare(T n, T m) {
        if (n == null && m == null) {
            return 0;
        }
        if (n == null) {
            return -1;
        }
        if (m == null) {
            return 1;
        }
        return n.compareTo(m);
    }

    public String toString() {
        return this.isNone() ? NONE_STRING : this.major + (this.minor != null ? DOT + this.minor : "") + (this.micro != null ? DOT + this.micro : "") + (StringUtils.isNotBlank((String)this.classifier) ? DOT + this.classifier : "");
    }
}

