package com.atlassian.plugins.rest.common.util;

import com.atlassian.plugins.rest.common.security.AdminOnly;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.LicensedOnly;
import com.atlassian.plugins.rest.common.security.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.UnlicensedSiteAccess;
import com.atlassian.plugins.rest.common.security.UnrestrictedAccess;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.api.model.AbstractResource;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.function.Function;

/**
 * A helper class to provide annotation related functionality in one place
 * <p>
 * @since 6.3.0
 */
public class AnnotationUtils {
    public static final Class<Annotation>[] VALID_ANNOTATION_LIST = new Class[]{SystemAdminOnly.class, AdminOnly.class, LicensedOnly.class, UnlicensedSiteAccess.class, AnonymousSiteAccess.class, UnrestrictedAccess.class, AnonymousAllowed.class};

    private final AbstractMethod abstractMethod;

    public AnnotationUtils(final AbstractMethod abstractMethod) {
        this.abstractMethod = abstractMethod;
    }

    public Class<Annotation> getAnnotation() {
        Class<Annotation> annotation = null;
        Method aMethod = abstractMethod.getMethod();
        if(aMethod != null) {
            annotation = extractAnnotation(aMethod::getAnnotation);
        }

        if(annotation != null) {
            return annotation;
        }

        AbstractResource resource = abstractMethod.getResource();
        if(resource != null) {
            annotation = extractAnnotation(resource::getAnnotation);
        }

        if(annotation != null) {
            return annotation;
        }

        Package aPackage = aMethod != null ? aMethod.getDeclaringClass().getPackage() : resource != null ? resource.getResourceClass().getPackage() : null;

        return aPackage != null ? extractAnnotation(aPackage::getAnnotation) : annotation;
    }
    private Class<Annotation> extractAnnotation(Function<Class<Annotation>, Annotation> function) {
        for (Class<Annotation> annotation : VALID_ANNOTATION_LIST) {
            if(function.apply(annotation) != null) {
                return annotation;
            }
        }
        return null;
    }

}