package com.atlassian.plugins.rest.common.error.jersey;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A generic exception mapper that will map any {@link Throwable throwable}.  Handles the special case of
 * {@link WebApplicationException}, which provides its own response.
 *
 * @since 1.0
 */
@Provider
public class ThrowableExceptionMapper implements ExceptionMapper<Throwable>
{
    private static final Logger log = LoggerFactory.getLogger(ThrowableExceptionMapper.class);

    @Context
    Request request;

    public Response toResponse(Throwable t)
    {
        log.error("Uncaught exception thrown by REST service", t);

        if (t instanceof WebApplicationException)
        {
            return ((WebApplicationException)t).getResponse();
        }
        else
        {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR)
                    .entity(new UncaughtExceptionEntity(t))
                    .type(UncaughtExceptionEntity.variantFor(request))
                    .build();
        }
    }
}
