/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.expand.entity;

import com.atlassian.plugins.rest.common.expand.entity.ListWrapper;
import com.atlassian.plugins.rest.common.expand.entity.ListWrapperCallback;
import com.atlassian.plugins.rest.common.expand.parameter.Indexes;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractPagedListWrapper<T>
implements ListWrapper<T> {
    @XmlAttribute
    private final int size;
    @XmlAttribute(name="max-results")
    private final int maxResults;
    @XmlAttribute(name="start-index")
    private Integer startIndex;

    private AbstractPagedListWrapper() {
        this.size = 0;
        this.maxResults = 0;
    }

    protected AbstractPagedListWrapper(int size, int maxResults) {
        this.size = size;
        this.maxResults = maxResults;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public int getSize() {
        return this.size;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    @Override
    public final ListWrapperCallback<T> getCallback() {
        return new ListWrapperCallback<T>(){

            @Override
            public List<T> getItems(Indexes indexes) {
                int startIndex = indexes.getMinIndex(AbstractPagedListWrapper.this.size);
                if (startIndex != -1) {
                    AbstractPagedListWrapper.this.setStartIndex(startIndex);
                }
                return AbstractPagedListWrapper.this.getPagingCallback().getItems(indexes);
            }
        };
    }

    public abstract ListWrapperCallback<T> getPagingCallback();
}

