/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.security.jersey;

import com.atlassian.plugins.rest.common.security.XsrfCheckFailedException;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.ws.rs.core.MediaType;

public class XsrfResourceFilter
implements ResourceFilter,
ContainerRequestFilter {
    public static final String TOKEN_HEADER = "X-Atlassian-Token";
    public static final String NO_CHECK = "nocheck";
    private static final Set<String> XSRFABLE_TYPES = new HashSet<String>(Arrays.asList("application/x-www-form-urlencoded", "multipart/form-data", "text/plain"));

    public ContainerRequest filter(ContainerRequest request) {
        String header;
        if (this.isXsrfable(request) && ((header = request.getHeaderValue(TOKEN_HEADER)) == null || !header.toLowerCase(Locale.ENGLISH).equals(NO_CHECK))) {
            throw new XsrfCheckFailedException();
        }
        return request;
    }

    private boolean isXsrfable(ContainerRequest request) {
        String method = request.getMethod();
        return method.equals("GET") || method.equals("POST") && XSRFABLE_TYPES.contains(XsrfResourceFilter.mediaTypeToString(request.getMediaType()));
    }

    public ContainerRequestFilter getRequestFilter() {
        return this;
    }

    public ContainerResponseFilter getResponseFilter() {
        return null;
    }

    private static String mediaTypeToString(MediaType mediaType) {
        return mediaType.getType().toLowerCase(Locale.ENGLISH) + "/" + mediaType.getSubtype().toLowerCase(Locale.ENGLISH);
    }
}

