/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.expand.resolver;

import com.atlassian.plugins.rest.common.expand.EntityCrawler;
import com.atlassian.plugins.rest.common.expand.EntityExpander;
import com.atlassian.plugins.rest.common.expand.ExpandContext;
import com.atlassian.plugins.rest.common.expand.ExpandException;
import com.atlassian.plugins.rest.common.expand.entity.ListWrapper;
import com.atlassian.plugins.rest.common.expand.resolver.AbstractEntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.common.util.ReflectionUtils;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListWrapperEntityExpanderResolver
extends AbstractEntityExpanderResolver {
    private static final ListWrapperEntityExpander EXPANDER = new ListWrapperEntityExpander();

    @Override
    public <T> EntityExpander<T> getExpander(Class<? extends T> type) {
        if (ListWrapper.class.isAssignableFrom(type)) {
            return EXPANDER;
        }
        throw new ExpandException(type + " doesn't implement " + ListWrapper.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListWrapperEntityExpander
    implements EntityExpander<ListWrapper<?>> {
        private ListWrapperEntityExpander() {
        }

        @Override
        public ListWrapper<?> expand(ExpandContext<ListWrapper<?>> context, EntityExpanderResolver expanderResolver, EntityCrawler entityCrawler) {
            Field[] fields;
            ListWrapper<?> entity = context.getEntity();
            HashSet collectionFields = Sets.newHashSet();
            for (Field field : fields = entity.getClass().getDeclaredFields()) {
                if (!Collection.class.isAssignableFrom(field.getType())) continue;
                collectionFields.add(field);
            }
            if (collectionFields.isEmpty()) {
                throw new RuntimeException("Entity " + entity.getClass() + " has no collection field, cannot expand.");
            }
            if (collectionFields.size() > 1) {
                throw new RuntimeException("Entity " + entity.getClass() + " has more than one collection field, cannot determine which collection to expand.");
            }
            ReflectionUtils.setFieldValue((Field)collectionFields.iterator().next(), entity, entity.getCallback().getItems(context.getEntityExpandParameter().getIndexes(context.getExpandable())));
            entityCrawler.crawl(entity, context.getEntityExpandParameter().getExpandParameter(context.getExpandable()), expanderResolver);
            return entity;
        }
    }
}

