/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.expand.resolver;

import com.atlassian.plugins.rest.common.expand.EntityCrawler;
import com.atlassian.plugins.rest.common.expand.EntityExpander;
import com.atlassian.plugins.rest.common.expand.ExpandConstraint;
import com.atlassian.plugins.rest.common.expand.ExpandContext;
import com.atlassian.plugins.rest.common.expand.ExpandException;
import com.atlassian.plugins.rest.common.expand.parameter.Indexes;
import com.atlassian.plugins.rest.common.expand.resolver.AbstractEntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandConstraintEntityExpanderResolver
extends AbstractEntityExpanderResolver {
    @Override
    public <T> EntityExpander<T> getExpander(Class<? extends T> type) {
        for (Method method : type.getDeclaredMethods()) {
            if (method.getAnnotation(ExpandConstraint.class) == null || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(Indexes.class)) continue;
            return new ExpandConstraintEntityExpander(method);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpandConstraintEntityExpander
    implements EntityExpander<Object> {
        private final Method method;

        public ExpandConstraintEntityExpander(Method method) {
            this.method = (Method)Preconditions.checkNotNull((Object)method);
        }

        @Override
        public Object expand(ExpandContext<Object> context, EntityExpanderResolver expanderResolver, EntityCrawler entityCrawler) {
            Object entity = context.getEntity();
            try {
                this.method.invoke(entity, context.getEntityExpandParameter().getIndexes(context.getExpandable()));
            }
            catch (IllegalAccessException e) {
                throw new ExpandException(e);
            }
            catch (InvocationTargetException e) {
                throw new ExpandException(e);
            }
            entityCrawler.crawl(entity, context.getEntityExpandParameter().getExpandParameter(context.getExpandable()), expanderResolver);
            return entity;
        }
    }
}

