package com.atlassian.plugins.rest.common.multipart.fileupload;

import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartHandler;
import com.google.common.base.Preconditions;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class CommonsFileUploadMultipartHandler implements MultipartHandler
{
    private final ServletFileUpload servletFileUpload;

    public CommonsFileUploadMultipartHandler(long maxFileSize)
    {
        servletFileUpload = new ServletFileUpload(new DiskFileItemFactory());
        servletFileUpload.setFileSizeMax(maxFileSize);
    }

    public FilePart getFilePart(HttpServletRequest request, String field)
    {
        if (!ServletFileUpload.isMultipartContent(request))
        {
            throw new RuntimeException("Not a multipart request");
        }

        try
        {
            for (FileItem item : getFileItems(request))
            {
                if (item.getFieldName().equals(field))
                {
                    return new CommonsFileUploadFilePart(item);
                }
            }
            throw new RuntimeException("balsdjlas");
        }
        catch (FileUploadException e)
        {
            throw new RuntimeException(e);
        }
    }

    @SuppressWarnings("unchecked")
    private List<FileItem> getFileItems(HttpServletRequest request) throws FileUploadException
    {
        return (List<FileItem>) servletFileUpload.parseRequest(request);
    }

    private static class CommonsFileUploadFilePart implements FilePart
    {
        private final FileItem fileItem;

        CommonsFileUploadFilePart(FileItem fileItem)
        {
            this.fileItem = Preconditions.checkNotNull(fileItem);
        }

        public String getName()
        {
            return fileItem.getName();
        }

        public InputStream getInputStream() throws IOException
        {
            return fileItem.getInputStream();
        }
    }
}
