package com.atlassian.plugins.less;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.lesscss.LessCompiler;
import com.atlassian.lesscss.Loader;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.util.PluginUtils;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.lesscss.spi.LessCssCompilationEvent;

import java.net.URI;

class LessResource extends CharSequenceDownloadableResource {

    /**
     * copied from com.atlassian.plugin.servlet.AbstractDownloadableResource
     */
    private static final String ATLASSIAN_WEBRESOURCE_DISABLE_MINIFICATION = "atlassian.webresource.disable.minification";

    private final LessCompiler compiler;
    private final Loader loader;
    private final URI resourceUri;
    private final EventPublisher eventPublisher;

    public LessResource(DownloadableResource originalResource, LessCompiler compiler, Loader loader, URI resourceUri, EventPublisher eventPublisher) {
        super(originalResource);
        this.compiler = compiler;
        this.loader = loader;
        this.resourceUri = resourceUri;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public String getContentType() {
        return "text/css";
    }

    @Override
    protected CharSequence transform(CharSequence original) {
        eventPublisher.publish(new LessCssCompilationEvent(resourceUri));
        boolean compress = !isMinificationDisabled();
        return compiler.compile(loader, resourceUri, original, compress);
    }

    private static boolean isMinificationDisabled() {
        return Boolean.getBoolean(ATLASSIAN_WEBRESOURCE_DISABLE_MINIFICATION) || Boolean.getBoolean(PluginUtils.ATLASSIAN_DEV_MODE);
    }

}
