package com.atlassian.plugins.less;

import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.webresource.api.prebake.Coordinate;
import com.atlassian.webresource.api.prebake.DimensionAwareTransformerUrlBuilder;

import java.net.URI;
import java.util.List;

public class LessTransformerUrlBuilder implements DimensionAwareTransformerUrlBuilder {
    private final List<URI> resources;
    private final UriStateManager uriStateManager;

    public LessTransformerUrlBuilder(List<URI> resources, UriStateManager uriStateManager)
    {
        this.resources = resources;
        this.uriStateManager = uriStateManager;
    }

    @Override
    public void addToUrl(UrlBuilder urlBuilder, Coordinate coord) {
        for (URI uri : resources) {
            PrebakeStateResult stateResult = uriStateManager.getState(uri, coord);
            urlBuilder.addToHash("LESS-URI-STATE", stateResult.getState());

            if (!stateResult.getPrebakeErrors().isEmpty())
            {
                LessPrebakeError error = new LessPrebakeError(uri.getPath(), stateResult.getPrebakeErrors());
                urlBuilder.addPrebakeError(error);
            }
        }
    }

    @Override
    public void addToUrl(UrlBuilder urlBuilder) {
        for (URI uri : resources) {
            urlBuilder.addToHash("LESS-URI-STATE", uriStateManager.getState(uri));
        }
    }
}