AJS.namespace("JIRA.AttachImagesPlugin");

(function ($, _) {
    /**
     * AMD-ish pattern akin to require('deployJava').
     *
     * Oracle provides a JavaScript function -- deployJava -- that makes it easy to install Java in the browser.
     * @returns a jQuery promise that's resolved with two arguments:
     *     - {Function} `deployJava`
     *     - {WindowProxy} the contentWindow where `deployJava` exists.
     */
    JIRA.AttachImagesPlugin.requireDeployJava = _.once(function () {
        "use strict";
        var result = $.Deferred();

        if (window["deployJava"]) {
            result.resolve(window["deployJava"], window);
        } else {
            $('<iframe style="display: none !important; visibility: hidden !important; opacity: 0"/>')
                .attr('src', AJS.contextPath() + "/download/resources/com.atlassian.plugins.jira-html5-attach-images:jira-html5-attach-images-resources/applet/deployJava.html")
                .one('load', function () {
                    var contentWindow = this.contentWindow;
                    result.resolve(contentWindow["deployJava"], contentWindow);
                })
                .one('error', _.bind(result.reject, result))
                .appendTo('body');
        }
        return result;
    });
})(AJS.$, _);