AJS.test.require("com.atlassian.plugins.jira-html5-attach-images:jira-html5-attach-images-resources");

(function($) {
    "use strict";

    module("JIRA.AttachImagesPlugin", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.makeRequestStub = this.sandbox.stub(JIRA.SmartAjax, "makeRequest");
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("Test Validation For Good Data", function () {
        var content = ["<a id=\"a\"><b id=\"b\">hey!<\/b><\/a>"];
        var file = content; // the blob
        var fileName = "buggy-image.png";

        // Mocking view methods
        this.dialogViewMock = this.sandbox.mock(JIRA.AttachImagesPlugin.handler.dialogView);
        this.dialogViewMock.expects("getFileSize").once().returns(100);
        this.dialogViewMock.expects("getMaxSize").once().returns(1024);

        var errors = JIRA.AttachImagesPlugin.handler.validateFormData(file, fileName);
        ok($.isEmptyObject(errors), "fileName and fileUpload are good");
    });

    test("Test Validation For Empty File and File Name", function () {
        var file = {};
        var fileName = "";

        this.dialogViewMock = this.sandbox.mock(JIRA.AttachImagesPlugin.handler.dialogView);
        this.dialogViewMock.expects("buildPasteCatcher").once().returns({});
        JIRA.AttachImagesPlugin.handler.initScreenshotPasteHandler();

        var errors = JIRA.AttachImagesPlugin.handler.validateFormData(file, fileName);
        ok("fileName" in errors, "fileName is illegal");
        ok("fileUpload" in errors, "fileUpload is illegal");
    });

    test("Test Validation For Empty File and Good File Name", function () {
        var file = {};
        var fileName = "attachment.png";

        this.dialogViewMock = this.sandbox.mock(JIRA.AttachImagesPlugin.handler.dialogView);
        this.dialogViewMock.expects("buildPasteCatcher").once().returns({});
        JIRA.AttachImagesPlugin.handler.initScreenshotPasteHandler();
        var errors = JIRA.AttachImagesPlugin.handler.validateFormData(file, fileName);
        ok(! ("fileName" in errors), "fileName is is good");
        ok("fileUpload" in errors, "fileUpload is illegal");
    });

    test("Test Validation For Good File and Empty File Name", function () {
        var content = ["<a id=\"a\"><b id=\"b\">hey!<\/b><\/a>"];
        var file = content; // the blob
        var fileName = "";

        // Mocking view methods
        this.dialogViewMock = this.sandbox.mock(JIRA.AttachImagesPlugin.handler.dialogView);
        this.dialogViewMock.expects("getFileSize").once().returns(100);
        this.dialogViewMock.expects("getMaxSize").once().returns(1024);


        var errors = JIRA.AttachImagesPlugin.handler.validateFormData(file, fileName);
        ok("fileName" in errors, "fileName is is illegal");
        ok(!("fileUpload" in errors), "fileUpload is good");
    });

    test("Test Validation For Good File and Illegal chars in File Name", function () {
        var content = ["<a id=\"a\"><b id=\"b\">hey!<\/b><\/a>"];
        var file = content; // the blob
        var fileName = "<>>>!";

        // Mocking view methods
        this.dialogViewMock = this.sandbox.mock(JIRA.AttachImagesPlugin.handler.dialogView);
        this.dialogViewMock.expects("getFileSize").once().returns(100);
        this.dialogViewMock.expects("getMaxSize").once().returns(1024);


        var errors = JIRA.AttachImagesPlugin.handler.validateFormData(file, fileName);
        ok("fileName" in errors, "fileName is is illegal");
        ok(!("fileUpload" in errors), "fileUpload is good");
    });

    test("Test PNG Extension validation", function () {

        ok(JIRA.AttachImagesPlugin.handler.dialogView.hasPngExtension("screenshot-1.png"), "Must recognize PNG extension");
        ok(JIRA.AttachImagesPlugin.handler.dialogView.hasPngExtension("screenshot-1.PNG"), "Must recognize PNG extension");
        ok(JIRA.AttachImagesPlugin.handler.dialogView.hasPngExtension("screenshot-1.PNG.PNG"), "Must recognize PNG extension");

        ok(!(JIRA.AttachImagesPlugin.handler.dialogView.hasPngExtension("screenshot-1-PNG")), "Must NOT recognize PNG extension");
        ok(!(JIRA.AttachImagesPlugin.handler.dialogView.hasPngExtension("screenshot-1.PNG.JPG")), "Must NOT recognize PNG extension");
        ok(!(JIRA.AttachImagesPlugin.handler.dialogView.hasPngExtension("PNG.screenshot-1")), "Must NOT recognize PNG extension");
    });

})(jQuery);







