(function($) {
    function nope() { return false; }
    function yep() { return true; }

    var cidCounter = 0, seed = new Date().getTime();

    // to un-fuck graphite event names
    function cleanAnalyticsName(name) {
        name = "" + (name || "");
        return name.replace(/\./g, "-");
    }

    function analytics(eventId, model) {
        if (AJS.EventQueue && model && model.attributes.id) {
            var event = {};
            var cleanId = cleanAnalyticsName(model.attributes.id);
            event.name = "helptips." + cleanId + "." + eventId;
            event.properties = {};
            AJS.EventQueue.push(event);
        }
    }

    function getCid() {
        return "c" + seed + (cidCounter++);
    }

    /**
     * @param attributes
     * @param attributes.id
     * @param attributes.callbacks callbacks used by helptip and passed into AJS.InlineDialog
     * @param attributes.callbacks.beforeShow {jQuery.Deferred() | Function} called before rendering the helptip
     * @param attributes.callbacks.init {Function} passed into AJS.InlineDialog as initCallback param
     * @param attributes.callbacks.hide {Function} passed into AJS.InlineDialog as hideCallback param
     * @param attributes.isSequence {Boolean} to indicate whether this helptip should be shown in sequence
     *        see https://developer.atlassian.com/design/latest/feature-discovery.html
     * @param attributes.weight {Integer} the weight of the helptip determining the order to be shown in sequence
     * @param attributes.body {String} the HTML body content of the helptip
     * @param attributes.bodyHtml {String} same as attributes.body
     * @param attributes.inlineDialogOpts {Map} passed into AJS.InlineDialog as options, This will replace all the defaults specified by HelpTip
     * 
     * @type {Function}
     */
    var HelpTip = AJS.HelpTip = function(attributes) {
        var anchor;
        this.attributes = $.extend({}, attributes);
        this.attributes.id || (this.attributes.id = false);
        this.attributes.callbacks || (this.attributes.callbacks = {});

        //Allows the helptip to be shown in sequence via next button
        if (this.attributes.isSequence) {
            if(!this.attributes.weight) {
                this.attributes.weight = Number.MAX_VALUE;
            }
            AJS.HelpTip.Manager.sequences.push(this);
        }

        // Map renamed attribute body to bodyHtml
        if (this.attributes.body) {
            this.attributes.bodyHtml = this.attributes.body;
            delete this.attributes.body;
        }
        this.cid = getCid();
        anchor = this.attributes['anchor'];
        delete this.attributes['anchor'];

        this.view = (anchor) ? new AnchoredView(this, anchor) : new UnanchoredView(this);
        this.view.$el.addClass('aui-help-tip');
    };

    $.extend(HelpTip.prototype, {
        /**
         * @param options.force render the helptip regardless of the display controller
         */
        show: function(options) {
            options = options || {};

            var self = this;
            var showDeferred = $.Deferred();
            if (this.attributes.callbacks.beforeShow) {
                var beforeShowDeferred = this.attributes.callbacks.beforeShow();
                if (beforeShowDeferred && _.isFunction(beforeShowDeferred.done)) {
                    beforeShowDeferred.done(showDeferred.resolve)
                } else {
                    showDeferred.resolve();
                }
            } else {
                showDeferred.resolve();
            }

            showDeferred.done(function() {
                AJS.HelpTip.Manager.show(function() {
                    if (!self.isDismissed()) {
                        if (!options.force && AJS.Popups && AJS.Popups.DisplayController) {
                            AJS.Popups.DisplayController.request({
                                name:self.id,
                                weight:1000,
                                show:function () {
                                    self.view.show();
                                }})
                        } else {
                            self.view.show();
                        }
                        analytics("shown", self);
                    }
                });
            });
        },
        dismiss: function() {
            var reason = cleanAnalyticsName(arguments[0] || "programmatically");
            this.view.dismiss();
            //Clicking close should stop other helptip in sequence from showing
            if (reason === "close-button" && this.attributes.isSequence) {
                AJS.HelpTip.Manager.clearSequences();
            }
            if (!this.isDismissed()) {
                AJS.HelpTip.Manager.dismiss(this);
                analytics("dismissed." + reason, this);
            }
        },
        isVisible: function() {
            return this.view.$el.is(":visible");
        },
        isDismissed: function() {
            return AJS.HelpTip.Manager.isDismissed(this);
        }
    });

    var AnchoredView = function(model, anchor) {
        this.initialize(model, anchor);
    };

    $.extend(AnchoredView.prototype, {
        initialize: function(model, anchor) {
            var self = this;
            this.model = model;
            this.beforeHide = nope;
            this.popup = AJS.InlineDialog(anchor, model.cid, _.bind(this._createDialog, this), _.extend({
                // Use a container other than body, so that the positioning works when there are client-rendered banner messages
                container: "#content",
                noBind: true,
                preHideCallback: function() { return self.beforeHide() },
                calculatePositions: function(popup, targetPosition, mousePosition, opts) {
                    // Adjust positions relative to the container
                    var cssData = AJS.InlineDialog.opts.calculatePositions(popup, targetPosition, mousePosition, opts);
                    var $container = $(this.container);
                    cssData.popupCss.top -= $container.offset().top;
                    cssData.popupCss.left -= $container.offset().left;
                    return cssData;
                },
                addActiveClass: false,
                initCallback: model.attributes.callbacks.init,
                hideCallback: model.attributes.callbacks.hide
            }, model.attributes.inlineDialogOpts));
            this._popupHide = this.popup.hide;
            this.popup.hide = nope;
            this.$el = $(this.popup[0]);
            AJS.$(document).bind("showLayer",function(e,type,layer) {
                if (type === "inlineDialog" && layer.id === model.cid) {
                    AJS.InlineDialog.current = null; // Tips shouldn't be considered InlineDialogs.
                    AJS.$(document.body).unbind("click."+model.cid+".inline-dialog-check");
                    layer._validateClickToClose = nope;
                    layer.hide = nope;
                }
            });
        },
        show: function() {
            this.popup.show();
        },
        dismiss: function() {
            this.beforeHide = yep;
            this._popupHide();
        },
        _createDialog: function(content, trigger, show) {
            var instance = this;
            var sequenceDialogs = AJS.HelpTip.Manager.sequences;
            var position = this.model.attributes.position;

            content.html($(AJS.Templates.HelpTip.tipContent(_.extend({
                hasSequence: (sequenceDialogs.length > 1 && (position+1 < sequenceDialogs.length)),
                length: sequenceDialogs.length,
                position: position
            }, this.model.attributes))));

            content.unbind('mouseover mouseout');
            content.find(".helptip-link").click(function() {
                analytics("learn-more.clicked", instance.model);
            });
            content.find(".helptip-close").click(function(e) {
                e.preventDefault();
                instance.model.dismiss("close-button");
            });
            content.find(".helptip-next").click(function(e) {
                e.preventDefault();
                instance.model.dismiss("next-button");
                var next = position + 1;
                sequenceDialogs[next] && (sequenceDialogs[next].show({force: true}));
            });
            show();
        }
    });

    var UnanchoredView = function(model) {
        this.initialize(model);
    };

    $.extend(UnanchoredView.prototype, {
        initialize: function() {
            this.$el = $("<div></div>");
        },
        show: function() { },
        dismiss: function() { }
    });
})(AJS.$);
