AJS.test.require("com.atlassian.plugins.helptips.jira-help-tips:common");
AJS.test.require("com.atlassian.plugins.helptips.jira-help-tips:sinon");
test("existence of the feature can be asserted",function(){ok(AJS.HelpTip,"the AJS.HelpTip object should exist (and be truthy)")
});
test("can create new tips",function(){var A=new AJS.HelpTip();
equal(typeof A,"object","should be an object")
});
test("get a unique client id (cid)",function(){var B=[];
for(var A=0;
A<20;
A++){B.push((new AJS.HelpTip()).cid)
}equal(AJS.$.unique(B).length,B.length,"should be as many unique ids as tips created")
});
test("can be programmatically dismissed",function(){var A=new AJS.HelpTip({body:"whee"});
ok(!A.isDismissed(),"has not been dismissed yet");
A.dismiss();
ok(A.isDismissed(),"should be dismissed")
});
test("can bind dismissal of tip to other elements",function(){var B=new AJS.HelpTip({body:"whee"});
var A=AJS.$("<a>click me to dismiss</a>");
A.click(function(){B.dismiss()
});
A.trigger("click");
ok(B.isDismissed(),"should be dismissed after clicking the anchor link")
});
test("tips with the same id have a linked dismissed value",function(){var B=sinon.stub(AJS.HelpTip.Manager,"sync");
var A=new AJS.HelpTip({id:"testtip",body:"firsttip"});
var C=new AJS.HelpTip({id:"testtip",body:"secondtip"});
A.dismiss();
ok(C.isDismissed(),"tip2 is considered dismissed because tip1 was.");
B.restore()
});
test("tips with no id are considered different",function(){var A=new AJS.HelpTip({body:"firsttip"});
var B=new AJS.HelpTip({body:"secondtip"});
A.dismiss();
ok(!B.isDismissed(),"tip2 is different to tip1 as neither have the same id.")
});
module("anchored tip",{setup:function(){AJS.$.fx.off=true;
this.fakeSync=sinon.stub(AJS.HelpTip.Manager,"sync");
this.fakeShow=sinon.stub(AJS.HelpTip.Manager,"show",function(A){A()
});
this.clock=sinon.useFakeTimers();
this.container=AJS.$("<div>").attr("id","content").appendTo(AJS.$("#qunit-fixture"));
this.box=AJS.$("<div></div>").appendTo(AJS.$("#qunit-fixture"));
this.anchor=AJS.$("<a>test</a>").appendTo(this.box);
this.tip=new AJS.HelpTip({body:"test "+new Date(),anchor:this.anchor})
},teardown:function(){this.container.remove();
this.box.remove();
this.tip=null;
this.clock.restore();
this.fakeSync.restore();
this.fakeShow.restore();
AJS.$.fx.off=false
}});
test("can be anchored to an element",function(){this.tip.show();
this.clock.tick(0);
ok(this.tip.isVisible(),"tip should be visible")
});
test("cannot be dismissed by clicking outside the tip",function(){this.tip.show();
this.clock.tick(0);
AJS.$(document.body).trigger("click");
ok(this.tip.isVisible(),"tip should still be visible");
ok(!this.tip.isDismissed(),"not dismissed yet")
});
test("tip disappears when dismissed",function(){this.tip.show();
this.clock.tick(0);
this.tip.dismiss();
this.clock.tick(0);
ok(!this.tip.isVisible(),"should no longer be visible")
});
test("can click a close button to dismiss",function(){this.tip.show();
this.clock.tick(0);
var A=AJS.$(".helptip-close",this.tip.view.$el);
ok(A.length,"there should be a button on the anchored tip to dismiss it");
ok(!this.tip.isDismissed(),"is not yet dismissed");
A.trigger("click");
this.clock.tick(0);
ok(this.tip.isDismissed(),"should be dismissed after clicking the close button")
});
test("once dismissed, cannot be re-opened",function(){this.tip.show();
this.clock.tick(0);
this.tip.dismiss();
this.clock.tick(0);
this.tip.show();
ok(!this.tip.isVisible(),"should not be visible once closed")
});
test("test inline dialog options is passed from helptip constructors",function(){expect(5);
function B(){}var D=sinon.stub(AJS,"InlineDialog");
D.returns({hide:jQuery.noop});
var A={offsetX:999,offsetY:-999,arrowOffsetX:9001,container:"fixture",initCallback:B};
new AJS.HelpTip({body:"test "+new Date(),anchor:this.anchor,callbacks:{init:jQuery.noop},inlineDialogOpts:A});
var C=D.args[0][3];
_.each(A,function(E,F){ok(C[F]===E,"options passed in from constructor should replace the default inline dialog options from helptip")
});
D.restore()
});
test("test helptips to be shown in sequence for next button",function(){AJS.$("#qunit-fixture").append("<a class='anchorOne'></a><a class='anchorTwo'></a>");
var B=new AJS.HelpTip({id:"seq1",body:"I am a test 1.",isSequence:true,anchor:".anchorOne"});
var A=new AJS.HelpTip({id:"seq2",body:"I am a test 2.",isSequence:true,anchor:".anchorTwo"});
AJS.HelpTip.Manager.loaded=AJS.$.Deferred();
AJS.HelpTip.Manager.showSequences();
AJS.HelpTip.Manager.loaded.resolve();
var C=AJS.$(".helptip-next",B.view.$el);
equal(AJS.$(".helptip-sequence-paging",B.view.$el).text(),"1/2","Helptips include paging when shown in sequence");
equal(C.length,1,"Helptips include next button when shown in sequence");
C.click();
equal(AJS.$(".helptip-sequence-paging",A.view.$el).text(),"2/2","Helptips include paging when shown in sequence");
equal(AJS.$(".helptip-close",A.view.$el).length,1,"Helptips include close button when it is the last one");
equal(AJS.$(".helptip-next",A.view.$el).length,0,"Helptips does not include next button when it is the last one");
AJS.HelpTip.Manager.dismissedTipIds=[];
AJS.HelpTip.Manager.loaded=AJS.$.Deferred();
AJS.HelpTip.Manager.clearSequences();
AJS.HelpTip.Manager.loaded.resolve()
});
test("test helptips to be shown in sequence for close button",function(){AJS.$("#qunit-fixture").append("<a class='anchorOne'></a><a class='anchorTwo'></a>");
var B=new AJS.HelpTip({id:"seq1",body:"I am a test 1.",isSequence:true,anchor:".anchorOne"});
var A=new AJS.HelpTip({id:"seq2",body:"I am a test 2.",isSequence:true,anchor:".anchorTwo"});
AJS.HelpTip.Manager.loaded=AJS.$.Deferred();
AJS.HelpTip.Manager.showSequences();
AJS.HelpTip.Manager.loaded.resolve();
var C=AJS.$(".helptip-close",B.view.$el);
C.click();
equal(AJS.$(".helptip-body",A.view.$el).length,0,"Closing the first tip shouldn't open the second tip");
AJS.HelpTip.Manager.dismissedTipIds=[];
AJS.HelpTip.Manager.loaded=AJS.$.Deferred();
AJS.HelpTip.Manager.clearSequences();
AJS.HelpTip.Manager.loaded.resolve()
});
test("test HelptipManager for tips to be shown in sequence",function(){AJS.$("#qunit-fixture").append("<a class='anchor'></a>");
var B=new AJS.HelpTip({id:"seq1",body:"I am a test 1.",isSequence:true,anchor:".anchor"});
var A=new AJS.HelpTip({id:"seq2",body:"I am a test 2.",isSequence:true,anchor:".anchor"});
equal(AJS.HelpTip.Manager.sequences.length,2,"Helptips to be shown in sequence is added to the list");
AJS.HelpTip.Manager.loaded=AJS.$.Deferred();
AJS.HelpTip.Manager.showSequences();
AJS.HelpTip.Manager.loaded.resolve();
equal(AJS.HelpTip.Manager.sequences.length,2,"Helptips to be shown in sequence is added to the list");
equal(AJS.$(".helptip-sequence-paging",B.view.$el).text(),"1/2","Helptips include paging when shown in sequence");
equal(AJS.$(".helptip-close",B.view.$el).length,1,"Helptips include close button when shown in sequence");
equal(AJS.$(".helptip-next",B.view.$el).length,1,"Helptips include next button when shown in sequence");
AJS.HelpTip.Manager.dismissedTipIds.push("seq2");
AJS.HelpTip.Manager.loaded=AJS.$.Deferred();
AJS.HelpTip.Manager.showSequences();
AJS.HelpTip.Manager.loaded.resolve();
equal(AJS.HelpTip.Manager.sequences.length,1,"Helptips that have already been dismissed will not show");
equal(AJS.$(".helptip-sequence-paging",B.view.$el).length,0,"Helptips do not include paging when it is the only one");
equal(AJS.$(".helptip-close",B.view.$el).length,1,"Helptips include close button when it is the only one");
equal(AJS.$(".helptip-next",B.view.$el).length,0,"Helptips does not include next button when it is the only one")
});
module("persistence",{setup:function(){var A=this.requests=[];
this.xhr=sinon.useFakeXMLHttpRequest();
this.xhr.onCreate=function(B){A.push(B)
}
},teardown:function(){this.xhr.restore()
}});
test("sends nothing to the server if no ID was set",function(){var A=new AJS.HelpTip({body:"I have no ID-ah!"});
A.dismiss();
equal(this.requests.length,0,"no request was made to the server.")
});
test("POSTs the dismissal of the tip to the server",function(){var A=new AJS.HelpTip({id:"testtip2",body:"I am a test."});
A.dismiss();
equal(this.requests.length,1,"A request was sent to the server");
equal(this.requests[0].requestBody,JSON.stringify({id:"testtip2"}))
});