/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.projectcreate.crud;

import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.plugins.projectcreate.crud.exception.CreateSpaceFailureException;
import com.atlassian.confluence.plugins.projectcreate.crud.service.SpaceCreator;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceCachingBandanaPersister;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.projectcreate.spi.AggregateRoot;
import com.atlassian.plugins.projectcreate.spi.AggregateRootSubType;
import com.atlassian.plugins.projectcreate.spi.AggregateRootTypeCapability;
import com.atlassian.plugins.projectcreate.spi.ResponseStatusWithMessage;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

public class ConfluenceAggregateRootTypeCapability
implements AggregateRootTypeCapability {
    private static int SPACE_LOAD_LIMIT = 15;
    private final SpaceManager spaceManager;
    private final SpaceService spaceService;
    private final UserAccessor userAccessor;
    private final PermissionManager permissionManager;
    private final CacheManager cacheManager;
    private final Function<com.atlassian.confluence.api.model.content.Space, AggregateRoot> spaceToAggregateRootFunction;
    private final SpaceCreator spaceCreator;

    public ConfluenceAggregateRootTypeCapability(SpaceService spaceService, UserAccessor userAccessor, PermissionManager permissionManager, CacheManager cacheManager, final ApplicationProperties applicationProperties, SpaceCreator spaceCreator, SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
        this.spaceService = spaceService;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.cacheManager = cacheManager;
        this.spaceCreator = spaceCreator;
        this.spaceToAggregateRootFunction = new Function<com.atlassian.confluence.api.model.content.Space, AggregateRoot>(){

            public AggregateRoot apply(com.atlassian.confluence.api.model.content.Space input) {
                return AggregateRoot.makeAggregateRoot((String)input.getKey(), (String)input.getName(), (String)(applicationProperties.getBaseUrl(UrlMode.CANONICAL) + "/display/"));
            }
        };
    }

    public String getType() {
        return "confluence.space";
    }

    public String getLabelI18nKey() {
        return "confluence.projectcreate.space.label";
    }

    public String getDescriptionI18nKey() {
        return "confluence.projectcreate.space.description";
    }

    public boolean isAvailable() {
        return true;
    }

    public Iterable<AggregateRootSubType> getSubTypes() {
        return ImmutableList.of();
    }

    public Iterable<AggregateRoot> getExistingRoots() {
        boolean hasMore;
        ArrayList spaces = new ArrayList();
        int start = 0;
        do {
            PageResponse results = this.spaceService.find(new Expansion[0]).fetchMany((PageRequest)new SimplePageRequest(start, SPACE_LOAD_LIMIT));
            spaces.addAll(results.getResults());
            hasMore = results.hasMore();
            start += SPACE_LOAD_LIMIT;
        } while (hasMore);
        return Iterables.transform(spaces, this.spaceToAggregateRootFunction);
    }

    public Either<ResponseStatusWithMessage, AggregateRoot> createRoot(final String username, final String key, final String name, Option<String> subtypeKey, final Map<String, String> context) {
        return (Either)subtypeKey.fold((Supplier)new Supplier<Either<ResponseStatusWithMessage, AggregateRoot>>(){

            public Either<ResponseStatusWithMessage, AggregateRoot> get() {
                final ConfluenceUser user = ConfluenceAggregateRootTypeCapability.this.userAccessor.getUserByName(username);
                Option<ResponseStatusWithMessage> maybeError = ConfluenceAggregateRootTypeCapability.this.validateNewSpace(user, key, name, context);
                return (Either)maybeError.fold((Supplier)new Supplier<Either<ResponseStatusWithMessage, AggregateRoot>>(){

                    public Either<ResponseStatusWithMessage, AggregateRoot> get() {
                        try {
                            return Either.right((Object)ConfluenceAggregateRootTypeCapability.this.spaceToAggregateRootFunction.apply((Object)ConfluenceAggregateRootTypeCapability.this.spaceCreator.createSpace(user, key, name, context)));
                        }
                        catch (CreateSpaceFailureException e) {
                            return Either.left((Object)new ResponseStatusWithMessage(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), new String[0]));
                        }
                    }
                }, ConfluenceAggregateRootTypeCapability.toLeft());
            }
        }, (Function)new Function<String, Either<ResponseStatusWithMessage, AggregateRoot>>(){

            public Either<ResponseStatusWithMessage, AggregateRoot> apply(@Nullable String input) {
                return Either.left((Object)new ResponseStatusWithMessage(Response.Status.NOT_FOUND, "atlassian.project.create.unknown.subtype", new String[]{input}));
            }
        });
    }

    private static <L, R> Function<L, Either<L, R>> toLeft() {
        return new Function<L, Either<L, R>>(){

            public Either<L, R> apply(L input) {
                return Either.left(input);
            }
        };
    }

    public boolean canUserCreateRoot(String username) {
        User user = this.userAccessor.getUser(username);
        return this.permissionManager.hasCreatePermission(user, PermissionManager.TARGET_APPLICATION, com.atlassian.confluence.api.model.content.Space.class);
    }

    public Option<AggregateRoot> getRootByKey(Option<String> maybeUsername, String entityKey) {
        return this.spaceService.find(new Expansion[0]).withKeys(new String[]{entityKey}).fetchOne().map(this.spaceToAggregateRootFunction);
    }

    public Either<ResponseStatusWithMessage, ResponseStatusWithMessage> deleteRoot(String username, String entityKey) {
        User user = this.userAccessor.getUser(username);
        Space space = this.spaceManager.getSpace(entityKey);
        if (space == null || !this.permissionManager.hasPermission(user, Permission.VIEW, (Object)space)) {
            return Either.left((Object)new ResponseStatusWithMessage(Response.Status.NOT_FOUND, "confluence.projectcreate.space.delete.doesnt.exist", new String[0]));
        }
        if (!this.permissionManager.hasPermission(user, Permission.REMOVE, (Object)space)) {
            return Either.left((Object)new ResponseStatusWithMessage(Response.Status.FORBIDDEN, "confluence.projectcreate.space.delete.permission.denied", new String[0]));
        }
        Boolean removed = this.spaceManager.removeSpace(space);
        if (!removed.booleanValue()) {
            return Either.left((Object)new ResponseStatusWithMessage(Response.Status.INTERNAL_SERVER_ERROR, "", new String[0]));
        }
        return Either.right((Object)new ResponseStatusWithMessage(Response.Status.NO_CONTENT, "", new String[0]));
    }

    public Option<ResponseStatusWithMessage> validateNewSpace(ConfluenceUser user, String key, String name, Map<String, String> context) {
        Option<String> results = this.spaceCreator.validateCreateSpace(user, key, name, context);
        if (results.isEmpty()) {
            return Option.none();
        }
        return Option.some((Object)new ResponseStatusWithMessage(Response.Status.BAD_REQUEST, (String)results.get(), new String[0]));
    }

    public void flushPluginSettings() {
        this.cacheManager.getCache(ConfluenceCachingBandanaPersister.class.getName()).removeAll();
    }
}

