define('hipchat/invite/user-picker', [
    'jquery'
], function ($) {

    return function (field, form, options) {
        field = $(field);
        form = $(form);

        field.auiSelect2({
            ajax: {
                url: options.url,
                dataType: 'json',
                delay: 200,
                data: options.params,
                results: options.results,
                cache: true
            },
            multiple: true,
            minimumInputLength: 2
        });

        field.select2('focus');

        function onSelect(e) {
            var user = options.choice(e.choice);

            if(user.always) {
                // looks like a promise, so must be a duck,  wait for it to be done...
                user.always(function(user) {
                    if (!user.isRejected || !user.isRejected())
                        selectUser(user);
                });
            } else {
                // assume it's must be a user
                selectUser(user);
            }
        }

        function selectUser(user) {
            form.trigger('user-picker-user-selected', user);
            field.select2('val', '');
        }

        field.on('selected', onSelect);
    };

});
