/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.descriptor;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotification;
import io.atlassian.util.concurrent.ResettableLazyReference;
import org.dom4j.Element;

public class HipChatNotificationDescriptor
extends AbstractModuleDescriptor<HipChatNotification> {
    private String value;
    private String context;
    private String category;
    private int weight;
    private boolean activeByDefault;
    private final ResettableLazyReference<HipChatNotification> moduleReference = new ResettableLazyReference<HipChatNotification>(){

        protected HipChatNotification create() throws Exception {
            return HipChatNotificationDescriptor.this.createModule();
        }
    };

    public HipChatNotificationDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.value = element.attributeValue("value");
        this.context = element.attributeValue("context");
        this.category = element.attributeValue("category");
        this.weight = Integer.parseInt(element.attributeValue("weight", "1000"));
        this.activeByDefault = Boolean.valueOf(element.attributeValue("activeByDefault"));
    }

    public String getValue() {
        return this.value;
    }

    public String getContext() {
        return this.context;
    }

    public String getCategory() {
        return this.category;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isActiveByDefault() {
        return this.activeByDefault;
    }

    public HipChatNotification getModule() {
        return (HipChatNotification)this.moduleReference.get();
    }

    private HipChatNotification createModule() {
        return (HipChatNotification)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }
}

