/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.glances;

import com.atlassian.hipchat.api.glances.GlanceUpdateData;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class RoomAddonUiUpdateData {
    private final Collection<GlanceUpdateData> glances;

    private static <T> List<T> buildListFromArray(T[] elements) {
        if (elements == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(elements);
    }

    @JsonCreator
    public RoomAddonUiUpdateData(@JsonProperty(value="glance") GlanceUpdateData[] glances) {
        this(RoomAddonUiUpdateData.buildListFromArray(glances));
    }

    private RoomAddonUiUpdateData(Collection<GlanceUpdateData> glances) {
        this.glances = glances;
    }

    @JsonProperty(value="glance")
    public Collection<GlanceUpdateData> getGlances() {
        return this.glances;
    }

    public static class Builder {
        private Set<GlanceUpdateData> glancesSet = new HashSet<GlanceUpdateData>();

        public Builder addGlances(GlanceUpdateData[] glances) {
            if (glances != null) {
                for (GlanceUpdateData glance : glances) {
                    this.glancesSet.add(glance);
                }
            }
            return this;
        }

        public Builder addGlances(Iterable<GlanceUpdateData> glances) {
            if (glances != null) {
                for (GlanceUpdateData glance : glances) {
                    this.glancesSet.add(glance);
                }
            }
            return this;
        }

        public Builder addGlance(@Nonnull GlanceUpdateData glance) {
            this.glancesSet.add(glance);
            return this;
        }

        public RoomAddonUiUpdateData build() {
            ImmutableList glancesList = ImmutableList.copyOf(this.glancesSet);
            return new RoomAddonUiUpdateData((Collection)glancesList);
        }
    }
}

