/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.link;

import com.atlassian.cache.compat.CacheFactory;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.hipchat.api.events.HipChatServerRegistrationEvent;
import com.atlassian.plugins.hipchat.api.link.DefaultHipChatDomainManager;
import com.atlassian.plugins.hipchat.api.link.HipChatDomainManager;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="cachedHipChatDomainManager")
public class CachedHipChatDomainManager
implements HipChatDomainManager,
InitializingBean,
DisposableBean {
    private static final long DEFAULT_TTL = 180L;
    private static final String CACHE_NAME = "hipchat-group";
    private final CachedReference<String> domainCache;
    private final EventPublisher eventPublisher;

    @Autowired
    public CachedHipChatDomainManager(EventPublisher eventPublisher, CacheFactory cacheFactory, final @Qualifier(value="defaultHipChatDomainManager") HipChatDomainManager hipChatDomainManager) {
        this.eventPublisher = eventPublisher;
        CacheSettings settings = new CacheSettingsBuilder().expireAfterAccess(180L, TimeUnit.MINUTES).flushable().replicateViaInvalidation().build();
        this.domainCache = cacheFactory.getCachedReference(DefaultHipChatDomainManager.class, CACHE_NAME, new Supplier<String>(){

            @Override
            public String get() {
                return hipChatDomainManager.getDefaultDomain();
            }
        }, settings);
    }

    @Override
    @Nonnull
    public String getDefaultDomain() {
        return this.domainCache.get();
    }

    @EventListener
    public void onHipChatOAuthChanges(HipChatServerRegistrationEvent event) {
        this.domainCache.reset();
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }
}

