/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.connect.descriptor;

import com.atlassian.hipchat.api.HipChatScope;
import com.atlassian.hipchat.api.connect.descriptor.ConnectDescriptorCompatibility;
import com.atlassian.hipchat.api.connect.descriptor.HipChatApiConsumer;
import com.atlassian.hipchat.api.connect.descriptor.HipChatCapability;
import com.atlassian.hipchat.api.connect.descriptor.Installable;
import com.atlassian.hipchat.api.connect.descriptor.OAuth2Consumer;
import com.atlassian.hipchat.api.connect.descriptor.Webhook;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Action;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Configurable;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Dialog;
import com.atlassian.hipchat.api.connect.descriptor.extensions.ExternalPage;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Glance;
import com.atlassian.hipchat.api.connect.descriptor.extensions.WebPanel;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"webhook", "oauth2Consumer", "hipchatApiConsumer", "installable", "webPanel", "action", "dialog", "externalPage", "glance"})
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ConnectDescriptorCapabilities {
    private static final Logger logger = LoggerFactory.getLogger(ConnectDescriptorCapabilities.class);
    private final List<Webhook> webhooks;
    private final Collection<WebPanel> webPanels;
    private final Collection<Action> actions;
    private final Configurable configurable;
    private final Collection<Dialog> dialogs;
    private final Collection<ExternalPage> externalPages;
    private final Collection<Glance> glances;
    private final OAuth2Consumer oauth2Consumer;
    private final HipChatApiConsumer hipChatApiConsumer;
    private final Installable installable;

    @JsonCreator
    public ConnectDescriptorCapabilities(@JsonProperty(value="webhook") Webhook[] webhooks, @JsonProperty(value="oauth2Consumer") OAuth2Consumer oauth2Consumer, @JsonProperty(value="hipchatApiConsumer") HipChatApiConsumer hipChatApiConsumer, @JsonProperty(value="installable") Installable installable, @JsonProperty(value="webPanel") WebPanel[] webPanels, @JsonProperty(value="action") Action[] actions, @JsonProperty(value="configurable") Configurable configurable, @JsonProperty(value="dialog") Dialog[] dialogs, @JsonProperty(value="externalPage") ExternalPage[] externalPages, @JsonProperty(value="glance") Glance[] glances) {
        this(ConnectDescriptorCapabilities.buildListFromArray(webhooks), oauth2Consumer, hipChatApiConsumer, installable, ConnectDescriptorCapabilities.buildListFromArray(webPanels), ConnectDescriptorCapabilities.buildListFromArray(actions), configurable, ConnectDescriptorCapabilities.buildListFromArray(dialogs), ConnectDescriptorCapabilities.buildListFromArray(externalPages), ConnectDescriptorCapabilities.buildListFromArray(glances));
    }

    private ConnectDescriptorCapabilities(List<Webhook> webhooks, OAuth2Consumer oauth2Consumer, HipChatApiConsumer hipChatApiConsumer, Installable installable, List<WebPanel> webPanels, List<Action> actions, Configurable configurable, List<Dialog> dialogs, List<ExternalPage> externalPages, List<Glance> glances) {
        this.webhooks = Collections.unmodifiableList(webhooks);
        this.oauth2Consumer = oauth2Consumer;
        this.hipChatApiConsumer = hipChatApiConsumer;
        this.installable = installable;
        this.webPanels = webPanels;
        this.actions = actions;
        this.configurable = configurable;
        this.dialogs = dialogs;
        this.externalPages = externalPages;
        this.glances = glances;
    }

    private static <T> List<T> buildListFromArray(T[] elements) {
        if (elements == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(elements);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="webhook")
    public Iterable<Webhook> getWebhooks() {
        return this.webhooks;
    }

    public OAuth2Consumer getOauth2Consumer() {
        return this.oauth2Consumer;
    }

    public HipChatApiConsumer getHipchatApiConsumer() {
        return this.hipChatApiConsumer;
    }

    public Installable getInstallable() {
        return this.installable;
    }

    @JsonProperty(value="webPanel")
    public Collection<WebPanel> getWebPanels() {
        return this.webPanels;
    }

    @JsonProperty(value="action")
    public Collection<Action> getActions() {
        return this.actions;
    }

    @JsonProperty(value="configurable")
    public Configurable getConfigurable() {
        return this.configurable;
    }

    @JsonProperty(value="dialog")
    public Collection<Dialog> getDialogs() {
        return this.dialogs;
    }

    @JsonProperty(value="externalPage")
    public Collection<ExternalPage> getExternalPages() {
        return this.externalPages;
    }

    @JsonProperty(value="glance")
    public Collection<Glance> getGlances() {
        return this.glances;
    }

    static ConnectDescriptorCapabilities cloneWithLimitedScopes(ConnectDescriptorCapabilities fromCapabilities, Set<HipChatScope> scopes) {
        HipChatApiConsumer clonedHipChatApiConsumer;
        HipChatApiConsumer fromHipChatApiConsumer = fromCapabilities.getHipchatApiConsumer();
        if (fromHipChatApiConsumer == null) {
            clonedHipChatApiConsumer = null;
        } else {
            HipChatScope[] scopesArray = scopes.toArray(HipChatScope.EMPTY_SCOPES_ARRAY);
            clonedHipChatApiConsumer = new HipChatApiConsumer(fromHipChatApiConsumer.getFromName(), scopesArray);
        }
        ConnectDescriptorCapabilities clonedCapabilities = ConnectDescriptorCapabilities.builder().addWebhooks(fromCapabilities.getWebhooks()).addActions(fromCapabilities.getActions()).addWebPanels(fromCapabilities.getWebPanels()).setOauth2Consumer(fromCapabilities.getOauth2Consumer()).setHipChatApiConsumer(clonedHipChatApiConsumer).setInstallable(fromCapabilities.getInstallable()).build();
        return clonedCapabilities;
    }

    static ConnectDescriptorCompatibility computeCompatibility(ConnectDescriptorCapabilities fromCapabilities, ConnectDescriptorCapabilities toCapabilities) {
        Preconditions.checkNotNull((Object)fromCapabilities);
        Preconditions.checkNotNull((Object)toCapabilities);
        HipChatApiConsumer fromHipChatApiConsumer = fromCapabilities.hipChatApiConsumer;
        HipChatApiConsumer toHipChatApiConsumer = toCapabilities.hipChatApiConsumer;
        HipChatScope[] fromScopes = ConnectDescriptorCapabilities.scopesOf(fromHipChatApiConsumer);
        HipChatScope[] toScopes = ConnectDescriptorCapabilities.scopesOf(toHipChatApiConsumer);
        ConnectDescriptorCompatibility compatibility = ConnectDescriptorCapabilities.computeScopeCompatibility(fromScopes, toScopes);
        compatibility = ConnectDescriptorCapabilities.computeCompatibility(compatibility, fromCapabilities.oauth2Consumer, toCapabilities.oauth2Consumer);
        compatibility = ConnectDescriptorCapabilities.computeCompatibility(compatibility, fromCapabilities.hipChatApiConsumer, toCapabilities.hipChatApiConsumer);
        compatibility = ConnectDescriptorCapabilities.computeCompatibility(compatibility, fromCapabilities.installable, toCapabilities.installable);
        compatibility = ConnectDescriptorCapabilities.computeCompatibility(compatibility, fromCapabilities.configurable, toCapabilities.configurable);
        compatibility = ConnectDescriptorCapabilities.calculateCompatibility(fromCapabilities.webhooks, toCapabilities.webhooks, compatibility, "webhooks");
        compatibility = ConnectDescriptorCapabilities.calculateCompatibility(fromCapabilities.actions, toCapabilities.actions, compatibility, "action");
        compatibility = ConnectDescriptorCapabilities.calculateCompatibility(fromCapabilities.webPanels, toCapabilities.webPanels, compatibility, "webPanel");
        compatibility = ConnectDescriptorCapabilities.calculateCompatibility(fromCapabilities.externalPages, toCapabilities.externalPages, compatibility, "externalPage");
        compatibility = ConnectDescriptorCapabilities.calculateCompatibility(fromCapabilities.dialogs, toCapabilities.dialogs, compatibility, "dialog");
        compatibility = ConnectDescriptorCapabilities.calculateCompatibility(fromCapabilities.glances, toCapabilities.glances, compatibility, "glance");
        return compatibility;
    }

    private static ConnectDescriptorCompatibility calculateCompatibility(Collection<? extends HipChatCapability> from, Collection<? extends HipChatCapability> to, ConnectDescriptorCompatibility compatibility, String descriptorParameter) {
        if (!from.containsAll(to)) {
            compatibility = ConnectDescriptorCompatibility.mostIncompatible(compatibility, ConnectDescriptorCompatibility.CAPABILITIES_ADDED);
            logger.info("Found discrepancies between original descriptor with {}. Capabilities added", (Object)descriptorParameter);
        }
        if (!to.containsAll(from)) {
            compatibility = ConnectDescriptorCompatibility.mostIncompatible(compatibility, ConnectDescriptorCompatibility.CAPABILITIES_REMOVED);
            logger.info("Found discrepancies between original descriptor with {}. Capabilities removed", (Object)descriptorParameter);
        }
        return compatibility;
    }

    public static void applyCapabilityChanges(ConnectDescriptorCapabilities fromCapabilities, ConnectDescriptorCapabilities toCapabilities, Builder originalPlusCapabilities) {
        Preconditions.checkNotNull((Object)fromCapabilities);
        Preconditions.checkNotNull((Object)toCapabilities);
        originalPlusCapabilities.addWebhooks(toCapabilities.getWebhooks()).setOauth2Consumer(toCapabilities.getOauth2Consumer()).setInstallable(toCapabilities.getInstallable()).setConfigurable(toCapabilities.getConfigurable());
        HipChatApiConsumer toHipChatApiConsumer = toCapabilities.getHipchatApiConsumer();
        if (toHipChatApiConsumer != null) {
            HipChatScope[] toCompatibleScopes;
            HipChatScope[] toScopes = toHipChatApiConsumer.getScopes();
            if (toScopes == null) {
                toCompatibleScopes = null;
            } else {
                HipChatApiConsumer fromHipChatApiConsumer = fromCapabilities.getHipchatApiConsumer();
                if (fromHipChatApiConsumer == null) {
                    toCompatibleScopes = HipChatScope.EMPTY_SCOPES_ARRAY;
                } else {
                    HipChatScope[] fromScopes = fromHipChatApiConsumer.getScopes();
                    toCompatibleScopes = Arrays.copyOf(fromScopes, fromScopes.length);
                }
            }
            HipChatApiConsumer toCompatibleHipChatApiConsumer = new HipChatApiConsumer(toHipChatApiConsumer.getFromName(), toCompatibleScopes);
            originalPlusCapabilities.setHipChatApiConsumer(toCompatibleHipChatApiConsumer);
        }
    }

    private static ConnectDescriptorCompatibility computeScopeCompatibility(HipChatScope[] fromScopes, HipChatScope[] toScopes) {
        Preconditions.checkNotNull((Object)fromScopes);
        Preconditions.checkNotNull((Object)toScopes);
        for (HipChatScope toCapabilityScope : toScopes) {
            if (ConnectDescriptorCapabilities.hasScope(fromScopes, toCapabilityScope)) continue;
            return ConnectDescriptorCompatibility.SCOPE_INCREASE;
        }
        return ConnectDescriptorCompatibility.COMPATIBLE;
    }

    private static boolean hasScope(HipChatScope[] candidateScopes, HipChatScope searchScope) {
        for (HipChatScope candidateScope : candidateScopes) {
            if (!candidateScope.equals((Object)searchScope)) continue;
            return true;
        }
        return false;
    }

    private static HipChatScope[] scopesOf(HipChatApiConsumer hipChatApiConsumer) {
        if (hipChatApiConsumer == null) {
            return HipChatScope.EMPTY_SCOPES_ARRAY;
        }
        HipChatScope[] scopes = hipChatApiConsumer.getScopes();
        if (scopes == null) {
            return HipChatScope.EMPTY_SCOPES_ARRAY;
        }
        return scopes;
    }

    private static ConnectDescriptorCompatibility computeCompatibility(ConnectDescriptorCompatibility prevCompatibility, HipChatCapability fromHipChatCapability, HipChatCapability toHipChatCapability) {
        Preconditions.checkNotNull((Object)((Object)prevCompatibility));
        if (toHipChatCapability != null && fromHipChatCapability == null) {
            return ConnectDescriptorCompatibility.mostIncompatible(prevCompatibility, ConnectDescriptorCompatibility.CAPABILITIES_ADDED);
        }
        if (toHipChatCapability == null && fromHipChatCapability != null) {
            return ConnectDescriptorCompatibility.mostIncompatible(prevCompatibility, ConnectDescriptorCompatibility.CAPABILITIES_REMOVED);
        }
        return prevCompatibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectDescriptorCapabilities)) {
            return false;
        }
        ConnectDescriptorCapabilities that = (ConnectDescriptorCapabilities)o;
        if (this.webhooks != null ? !this.webhooks.equals(that.webhooks) : that.webhooks != null) {
            return false;
        }
        if (this.dialogs != null ? !this.dialogs.equals(that.dialogs) : that.dialogs != null) {
            return false;
        }
        if (this.webPanels != null ? !this.webPanels.equals(that.webPanels) : that.webPanels != null) {
            return false;
        }
        if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) {
            return false;
        }
        if (this.externalPages != null ? !this.externalPages.equals(that.externalPages) : that.externalPages != null) {
            return false;
        }
        if (this.glances != null ? !this.glances.equals(that.glances) : that.glances != null) {
            return false;
        }
        if (this.oauth2Consumer != null ? !this.oauth2Consumer.equals(that.oauth2Consumer) : that.oauth2Consumer != null) {
            return false;
        }
        if (this.hipChatApiConsumer != null ? !this.hipChatApiConsumer.equals(that.hipChatApiConsumer) : that.hipChatApiConsumer != null) {
            return false;
        }
        if (this.configurable != null ? !this.configurable.equals(that.configurable) : that.configurable != null) {
            return false;
        }
        return !(this.installable == null ? that.installable != null : !this.installable.equals(that.installable));
    }

    public int hashCode() {
        int result = this.webhooks != null ? this.webhooks.hashCode() : 0;
        result = 31 * result + (this.webPanels != null ? this.webPanels.hashCode() : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        result = 31 * result + (this.dialogs != null ? this.dialogs.hashCode() : 0);
        result = 31 * result + (this.externalPages != null ? this.externalPages.hashCode() : 0);
        result = 31 * result + (this.glances != null ? this.glances.hashCode() : 0);
        result = 31 * result + (this.oauth2Consumer != null ? this.oauth2Consumer.hashCode() : 0);
        result = 31 * result + (this.hipChatApiConsumer != null ? this.hipChatApiConsumer.hashCode() : 0);
        result = 31 * result + (this.configurable != null ? this.configurable.hashCode() : 0);
        result = 31 * result + (this.installable != null ? this.installable.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ConnectDescriptorCapabilities{webhooks=" + this.webhooks + ", oauth2Consumer=" + this.oauth2Consumer + ", hipChatApiConsumer=" + this.hipChatApiConsumer + ", installable=" + this.installable + ", dialogs=" + this.dialogs + ", webPanels=" + this.webPanels + ", actions=" + this.actions + ", configurable=" + this.configurable + ", externalPages=" + this.externalPages + ", glances=" + this.glances + '}';
    }

    public static class Builder {
        private Set<Webhook> webhooksSet = new TreeSet<Webhook>();
        private Set<WebPanel> webPanels = new TreeSet<WebPanel>();
        private Set<Action> actions = new TreeSet<Action>();
        private Set<Dialog> dialogs = new TreeSet<Dialog>();
        private Set<ExternalPage> externalPages = new TreeSet<ExternalPage>();
        private Set<Glance> glances = new TreeSet<Glance>();
        private OAuth2Consumer oauth2Consumer;
        private HipChatApiConsumer hipchatApiConsumer;
        private Installable installable;
        private Configurable configurable;

        public Builder addWebhooks(Webhook[] webhooks) {
            if (webhooks != null) {
                for (Webhook webhook : webhooks) {
                    this.webhooksSet.add(webhook);
                }
            }
            return this;
        }

        public Builder addWebhooks(Iterable<Webhook> webhooks) {
            if (webhooks != null) {
                for (Webhook webhook : webhooks) {
                    this.webhooksSet.add(webhook);
                }
            }
            return this;
        }

        public Builder addWebPanels(@Nonnull Collection<WebPanel> webPanels) {
            this.webPanels.addAll(webPanels);
            return this;
        }

        public Builder addDialogs(@Nonnull Collection<Dialog> dialogs) {
            this.dialogs.addAll(dialogs);
            return this;
        }

        public Builder addActions(@Nonnull Collection<Action> actions) {
            this.actions.addAll(actions);
            return this;
        }

        public Builder addExternalPages(@Nonnull Collection<ExternalPage> externalPages) {
            this.externalPages.addAll(externalPages);
            return this;
        }

        public Builder addGlances(@Nonnull Collection<Glance> glances) {
            this.glances.addAll(glances);
            return this;
        }

        public Builder addWebhook(@Nonnull Webhook webhook) {
            this.webhooksSet.add(webhook);
            return this;
        }

        public Builder addWebPanel(@Nonnull WebPanel webPanel) {
            this.webPanels.add(webPanel);
            return this;
        }

        public Builder addAction(@Nonnull Action action) {
            this.actions.add(action);
            return this;
        }

        public void addDialog(@Nonnull Dialog dialog) {
            this.dialogs.add(dialog);
        }

        public void addExternalPage(@Nonnull ExternalPage externalPage) {
            this.externalPages.add(externalPage);
        }

        public void addGlance(@Nonnull Glance glance) {
            this.glances.add(glance);
        }

        public Builder setOauth2Consumer(OAuth2Consumer oauth2Consumer) {
            this.oauth2Consumer = oauth2Consumer;
            return this;
        }

        public Builder setHipChatApiConsumer(HipChatApiConsumer hipchatApiConsumer) {
            this.hipchatApiConsumer = hipchatApiConsumer;
            return this;
        }

        public Builder setInstallable(Installable installable) {
            this.installable = installable;
            return this;
        }

        public Builder setConfigurable(Configurable configurable) {
            this.configurable = configurable;
            return this;
        }

        public ConnectDescriptorCapabilities build() {
            ImmutableList webhooksList = ImmutableList.copyOf(this.webhooksSet);
            ImmutableList webPanelsList = ImmutableList.copyOf(this.webPanels);
            ImmutableList actionsList = ImmutableList.copyOf(this.actions);
            ImmutableList dialogsList = ImmutableList.copyOf(this.dialogs);
            ImmutableList externalPagesList = ImmutableList.copyOf(this.externalPages);
            ImmutableList glancesList = ImmutableList.copyOf(this.glances);
            return new ConnectDescriptorCapabilities((List)webhooksList, this.oauth2Consumer, this.hipchatApiConsumer, this.installable, (List)webPanelsList, (List)actionsList, this.configurable, (List)dialogsList, (List)externalPagesList, (List)glancesList);
        }
    }
}

