/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api;

import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.HipChatTokenReference;
import com.atlassian.hipchat.api.addons.AddonService;
import com.atlassian.hipchat.api.addons.DefaultAddonService;
import com.atlassian.hipchat.api.capabilities.CapabilitiesService;
import com.atlassian.hipchat.api.capabilities.DefaultCapabilitiesService;
import com.atlassian.hipchat.api.common.DefaultFeatureService;
import com.atlassian.hipchat.api.common.FeatureService;
import com.atlassian.hipchat.api.emoticons.DefaultEmoticonService;
import com.atlassian.hipchat.api.emoticons.EmoticonService;
import com.atlassian.hipchat.api.groups.GroupService;
import com.atlassian.hipchat.api.groups.impl.DefaultGroupService;
import com.atlassian.hipchat.api.healthcheck.DefaultHealthCheckService;
import com.atlassian.hipchat.api.healthcheck.HealthCheckService;
import com.atlassian.hipchat.api.rooms.RoomService;
import com.atlassian.hipchat.api.rooms.impl.DefaultRoomService;
import com.atlassian.hipchat.api.session.DefaultSessionService;
import com.atlassian.hipchat.api.session.SessionService;
import com.atlassian.hipchat.api.users.DefaultUserService;
import com.atlassian.hipchat.api.users.UserService;
import com.sun.jersey.api.client.Client;

public class DefaultHipChatAPI<T extends HipChatAPI.TokenType>
implements HipChatAPI<T> {
    private final HipChatRoutesProvider.Routes<T> routes;
    private final CapabilitiesService capabilitiesService;
    private final UserService userService;
    private final SessionService sessionService;
    private final EmoticonService emoticonService;
    private final RoomService roomsService;
    private final AddonService addonService;
    private final GroupService groupService;
    private final FeatureService featureService;
    private final HipChatAPI.TokenType tokenType;
    private final HealthCheckService healthCheckService;

    public DefaultHipChatAPI(HipChatAPI.TokenType tokenType, Client client, HipChatRoutesProvider.Routes<T> routes, String oAuthId, String oAuthSecret, ClientResponseMapper responseMapper) {
        this.tokenType = tokenType;
        this.routes = routes;
        this.capabilitiesService = new DefaultCapabilitiesService<T>(client, routes, responseMapper);
        this.sessionService = new DefaultSessionService<T>(client, oAuthId, oAuthSecret, routes, responseMapper);
        this.userService = new DefaultUserService<T>(client, routes, responseMapper);
        this.emoticonService = new DefaultEmoticonService<T>(client, routes, responseMapper);
        this.roomsService = new DefaultRoomService(routes, client, responseMapper);
        this.addonService = new DefaultAddonService<T>(responseMapper, routes, client);
        this.groupService = new DefaultGroupService<T>(routes, client, responseMapper);
        this.featureService = new DefaultFeatureService<T>(responseMapper, routes, client);
        this.healthCheckService = new DefaultHealthCheckService<T>(client, routes, responseMapper);
    }

    @Override
    public UserService users() {
        return this.userService;
    }

    @Override
    public SessionService sessions() {
        return this.sessionService;
    }

    @Override
    public HealthCheckService healthCheck() {
        return this.healthCheckService;
    }

    @Override
    public CapabilitiesService capabilities() {
        return this.capabilitiesService;
    }

    @Override
    public RoomService rooms() {
        return this.roomsService;
    }

    @Override
    public EmoticonService emoticons() {
        return this.emoticonService;
    }

    @Override
    public AddonService addons() {
        return this.addonService;
    }

    @Override
    public GroupService groups() {
        return this.groupService;
    }

    @Override
    public FeatureService features() {
        return this.featureService;
    }

    @Override
    public HipChatRoutesProvider.Routes<T> getRoutes() {
        return this.routes;
    }

    @Override
    public HipChatTokenReference getToken() {
        return this.routes.getToken();
    }

    @Override
    public HipChatAPI.TokenType getTokenType() {
        return this.tokenType;
    }
}

