/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.routes;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.Result;
import com.atlassian.plugins.hipchat.routes.RateLimitThresholdEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RateLimitMonitoringResourceMapper
implements ClientResponseMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RateLimitMonitoringResourceMapper.class);
    @VisibleForTesting
    static final int HTTP_TOO_MANY_REQUESTS = 429;
    @VisibleForTesting
    static final String HEADER_RATE_LIMIT_REMAINING = "X-RateLimit-Remaining";
    @VisibleForTesting
    static final String HEADER_RATE_LIMIT_LIMIT = "X-RateLimit-Limit";
    @VisibleForTesting
    static final String HEADER_RATE_LIMIT_RESET = "X-RateLimit-Reset";
    private final EventPublisher eventPublisher;
    private final ClientResponseMapper responseMapper;

    public RateLimitMonitoringResourceMapper(EventPublisher eventPublisher, ClientResponseMapper responseMapper) {
        this.eventPublisher = eventPublisher;
        this.responseMapper = responseMapper;
    }

    @Override
    public <T> Function<ClientResponse, Result<T>> to(Class<? extends T> clazz) {
        return Functions.compose(this.responseMapper.to(clazz), this.inspectRateLimitHeaders());
    }

    @Override
    public <T> Function<ClientResponse, Result.CacheableResult<T>> conditionalTo(Class<T> clazz) {
        return Functions.compose(this.responseMapper.conditionalTo(clazz), this.inspectRateLimitHeaders());
    }

    @Override
    public Function<ClientResponse, Result<Void>> toVoid() {
        return Functions.compose(this.responseMapper.toVoid(), this.inspectRateLimitHeaders());
    }

    @Override
    public <T> Function<ClientResponse, Result<T>> to(GenericType<? extends T> type) {
        return Functions.compose(this.responseMapper.to(type), this.inspectRateLimitHeaders());
    }

    public Function<ClientResponse, ClientResponse> inspectRateLimitHeaders() {
        return new Function<ClientResponse, ClientResponse>(){

            public ClientResponse apply(ClientResponse result) {
                MultivaluedMap headers = result.getHeaders();
                Option limitHeader = Option.option((Object)headers.getFirst((Object)RateLimitMonitoringResourceMapper.HEADER_RATE_LIMIT_LIMIT));
                Option remainingHeader = Option.option((Object)headers.getFirst((Object)RateLimitMonitoringResourceMapper.HEADER_RATE_LIMIT_REMAINING));
                Option resetHeader = Option.option((Object)headers.getFirst((Object)RateLimitMonitoringResourceMapper.HEADER_RATE_LIMIT_RESET));
                if (result.getStatus() == 429) {
                    LOGGER.error("Hipchat link has hit rate limit, {}/{} calls remaining. Resetting at {}", new Object[]{remainingHeader.getOrElse((Object)"(header missing)"), limitHeader.getOrElse((Object)"(header missing)"), resetHeader.getOrElse((Object)"(header missing)")});
                } else if (limitHeader.isDefined() && remainingHeader.isDefined() && resetHeader.isDefined()) {
                    int limit = Integer.parseInt((String)limitHeader.get());
                    int remaining = Integer.parseInt((String)remainingHeader.get());
                    long reset = RateLimitMonitoringResourceMapper.this.adaptUnixTimestamp((Option<String>)resetHeader);
                    int limitBreakpoints = limit / 10;
                    if (remaining % limitBreakpoints == 1) {
                        LOGGER.info("Hipchat link has crossed rate limit breakpoint, {} of {} calls used. Resetting at {}.", new Object[]{remaining, limit, reset});
                        RateLimitMonitoringResourceMapper.this.eventPublisher.publish((Object)new RateLimitThresholdEvent(limit, remaining, reset));
                    }
                }
                return result;
            }
        };
    }

    private long adaptUnixTimestamp(Option<String> resetHeader) {
        if (!resetHeader.isDefined()) {
            return 0L;
        }
        String value = (String)resetHeader.get();
        if (value.contains(".")) {
            value = value.substring(0, value.indexOf("."));
        }
        return Long.parseLong(value + "000");
    }
}

