/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.connect.descriptor;

import com.atlassian.hipchat.api.connect.descriptor.HipChatCapability;
import com.atlassian.hipchat.api.webhooks.RoomDeleted;
import com.atlassian.hipchat.api.webhooks.RoomMessage;
import com.atlassian.hipchat.api.webhooks.WebhookPayload;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class Webhook
implements HipChatCapability,
Comparable<Webhook> {
    private final URI url;
    private final String pattern;
    private final EventType event;
    private final String name;

    @JsonCreator
    public Webhook(@JsonProperty(value="url") URI url, @JsonProperty(value="pattern") String pattern, @JsonProperty(value="event") EventType event, @JsonProperty(value="name") String name) {
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)((Object)event));
        this.url = url;
        this.pattern = pattern;
        this.event = event;
        this.name = name;
    }

    public URI getUrl() {
        return this.url;
    }

    public String getPattern() {
        return this.pattern;
    }

    public EventType getEvent() {
        return this.event;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Webhook otherWebhook) {
        Preconditions.checkNotNull((Object)otherWebhook);
        int comparison = this.event.compareTo(otherWebhook.event);
        if (comparison == 0 && (comparison = this.url.compareTo(otherWebhook.url)) == 0 && (comparison = this.compareNullables(this.name, otherWebhook.name)) == 0) {
            comparison = this.compareNullables(this.pattern, otherWebhook.pattern);
        }
        return comparison;
    }

    private int compareNullables(String nullableA, String nullableB) {
        if (nullableA == null && nullableB == null) {
            return 0;
        }
        if (nullableA == null) {
            return -1;
        }
        if (nullableB == null) {
            return 1;
        }
        return nullableA.compareTo(nullableB);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook otherWebhook = (Webhook)o;
        if (this.event != otherWebhook.event) {
            return false;
        }
        if (this.name != null ? !this.name.equals(otherWebhook.name) : otherWebhook.name != null) {
            return false;
        }
        if (this.pattern != null ? !this.pattern.equals(otherWebhook.pattern) : otherWebhook.pattern != null) {
            return false;
        }
        return this.url.equals(otherWebhook.url);
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + (this.pattern != null ? this.pattern.hashCode() : 0);
        result = 31 * result + this.event.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HipChatApiConsumer{url='" + this.url + '\'' + "pattern='" + this.pattern + '\'' + "event='" + (Object)((Object)this.event) + '\'' + "name='" + this.name + '\'' + '}';
    }

    public static enum EventType {
        room_archived(RoomMessage.class),
        room_created(RoomMessage.class),
        room_deleted(RoomDeleted.class),
        room_enter(RoomMessage.class),
        room_exit(RoomMessage.class),
        room_file_upload(RoomMessage.class),
        room_message(RoomMessage.class),
        room_notification(RoomMessage.class),
        room_topic_change(RoomMessage.class),
        room_unarchived(RoomMessage.class);

        private final Class<? extends WebhookPayload> payloadClass;

        private EventType(Class<? extends WebhookPayload> payloadClass) {
            this.payloadClass = payloadClass;
        }

        public Class<? extends WebhookPayload> getPayloadClass() {
            return this.payloadClass;
        }
    }
}

