/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.filter.logout;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang3.StringUtils;

public class BambooLogoutFilter
implements Filter {
    static final String LOGOUT_QUERY_PARAMETER = "logout";
    private final SsoConfigService ssoConfigService;
    private final ApplicationProperties applicationProperties;

    @Inject
    public BambooLogoutFilter(@ComponentImport ApplicationProperties applicationProperties, SsoConfigService ssoConfigService) {
        this.ssoConfigService = ssoConfigService;
        this.applicationProperties = applicationProperties;
    }

    private boolean shouldRequestBeRedirected(HttpServletRequest request) {
        return StringUtils.isBlank(request.getParameter(LOGOUT_QUERY_PARAMETER));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        SsoConfig ssoConfig = this.ssoConfigService.getSsoConfig();
        if (ssoConfig != null && ssoConfig.isRedirectOnLogin() && this.shouldRequestBeRedirected(request)) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
            SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
            Authenticator authenticator = securityConfig.getAuthenticator();
            try {
                if (authenticator.getUser(request, response) != null) {
                    authenticator.logout(request, response);
                }
            }
            catch (AuthenticatorException e) {
                throw new ServletException((Throwable)e);
            }
            SecurityContextHolder.clearContext();
            response.sendRedirect(this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/plugins/servlet/sso-logout");
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }
}

