/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config;

import com.atlassian.plugins.authentication.impl.config.JustInTimeConfig;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class SsoConfig {
    private final boolean redirectOnLogin;
    private final boolean allowRedirectOverride;
    private final boolean includeCustomerLogins;
    private final boolean enableRememberMe;
    private final JustInTimeConfig justInTimeConfig;

    protected SsoConfig(boolean redirectOnLogin, boolean allowRedirectOverride, boolean includeCustomerLogins, boolean enableRememberMe, @Nonnull JustInTimeConfig justInTimeConfig) {
        Preconditions.checkNotNull((Object)justInTimeConfig);
        this.redirectOnLogin = redirectOnLogin;
        this.allowRedirectOverride = allowRedirectOverride;
        this.includeCustomerLogins = includeCustomerLogins;
        this.enableRememberMe = enableRememberMe;
        this.justInTimeConfig = justInTimeConfig;
    }

    @Nonnull
    public abstract SsoType getSsoType();

    public boolean isRedirectOnLogin() {
        return this.redirectOnLogin;
    }

    public boolean isAllowRedirectOverride() {
        return this.allowRedirectOverride;
    }

    public boolean isIncludeCustomerLogins() {
        return this.includeCustomerLogins;
    }

    public boolean isEnableRememberMe() {
        return this.enableRememberMe;
    }

    public JustInTimeConfig getJustInTimeConfig() {
        return this.justInTimeConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SsoConfig ssoConfig = (SsoConfig)o;
        return this.redirectOnLogin == ssoConfig.redirectOnLogin && this.allowRedirectOverride == ssoConfig.allowRedirectOverride && this.includeCustomerLogins == ssoConfig.includeCustomerLogins && this.enableRememberMe == ssoConfig.enableRememberMe && Objects.equals(this.justInTimeConfig, ssoConfig.justInTimeConfig);
    }

    public int hashCode() {
        return Objects.hash(this.justInTimeConfig, this.redirectOnLogin, this.allowRedirectOverride, this.includeCustomerLogins, this.enableRememberMe);
    }

    public abstract Builder toBuilder();

    public static abstract class Builder<T extends Builder> {
        protected boolean redirectOnLogin;
        protected boolean allowRedirectOverride;
        protected boolean includeCustomerLogins;
        protected boolean enableRememberMe = true;
        protected JustInTimeConfig justInTimeConfig = JustInTimeConfig.builder().setEnabled(false).build();

        protected Builder() {
        }

        protected Builder(@Nonnull SsoConfig ssoConfig) {
            this.redirectOnLogin = ssoConfig.isRedirectOnLogin();
            this.allowRedirectOverride = ssoConfig.isAllowRedirectOverride();
            this.includeCustomerLogins = ssoConfig.isIncludeCustomerLogins();
            this.enableRememberMe = ssoConfig.isEnableRememberMe();
            this.justInTimeConfig = ssoConfig.getJustInTimeConfig();
        }

        public T setRedirectOnLogin(boolean redirectOnLogin) {
            this.redirectOnLogin = redirectOnLogin;
            return (T)this;
        }

        public T setIncludeCustomerLogins(boolean includeCustomerLogins) {
            this.includeCustomerLogins = includeCustomerLogins;
            return (T)this;
        }

        public T setAllowRedirectOverride(boolean allowRedirectOverride) {
            this.allowRedirectOverride = allowRedirectOverride;
            return (T)this;
        }

        public T setEnableRememberMe(boolean enableRememberMe) {
            this.enableRememberMe = enableRememberMe;
            return (T)this;
        }

        public T setJustInTimeConfig(JustInTimeConfig justInTimeConfig) {
            this.justInTimeConfig = justInTimeConfig;
            return (T)this;
        }

        @Nonnull
        public abstract SsoConfig build();
    }
}

