/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.data;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.util.HttpsValidator;
import com.atlassian.plugins.authentication.impl.util.ProductLicenseDataProvider;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandler;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandlerProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationConstantsDataProvider
implements WebResourceDataProvider {
    private final ApplicationProperties applicationProperties;
    private final AuthenticationHandlerProvider authenticationHandlerProvider;
    private final HttpsValidator httpsValidator;
    private final ProductLicenseDataProvider productLicenseDataProvider;

    @Inject
    public ConfigurationConstantsDataProvider(@ComponentImport ApplicationProperties applicationProperties, AuthenticationHandlerProvider authenticationHandlerProvider, HttpsValidator httpsValidator, ProductLicenseDataProvider productLicenseDataProvider) {
        this.applicationProperties = applicationProperties;
        this.authenticationHandlerProvider = authenticationHandlerProvider;
        this.httpsValidator = httpsValidator;
        this.productLicenseDataProvider = productLicenseDataProvider;
    }

    public Jsonable get() {
        Gson gson = new Gson();
        AuthenticationHandler samlAuthHandler = this.authenticationHandlerProvider.getAuthenticationHandlerUnchecked(SsoType.SAML);
        AuthenticationHandler oidcAuthHandler = this.authenticationHandlerProvider.getAuthenticationHandlerUnchecked(SsoType.OIDC);
        return writer -> {
            String baseUrl = StringUtils.removeEnd(this.applicationProperties.getBaseUrl(UrlMode.CANONICAL), "/");
            gson.toJson((Object)ImmutableMap.builder().put((Object)"isServiceDesk", (Object)this.productLicenseDataProvider.isServiceDeskProduct()).put((Object)"isDataCenter", (Object)this.productLicenseDataProvider.isDataCenterProduct()).put((Object)"isHttps", (Object)this.httpsValidator.isBaseUrlSecure()).put((Object)"isHttpsRequired", (Object)this.httpsValidator.isHttpsRequired()).put((Object)"externalLoginUrl", (Object)(baseUrl + "/plugins/servlet/external-login")).put((Object)"samlServiceUrl", (Object)samlAuthHandler.getConsumerServletUrl()).put((Object)"samlEntityId", (Object)samlAuthHandler.getIssuerUrl()).put((Object)"oidcServiceUrl", (Object)oidcAuthHandler.getConsumerServletUrl()).put((Object)"oidcInitiateLoginUrl", (Object)(baseUrl + "/plugins/servlet/oidc/initiate-login")).build(), (Appendable)writer);
        };
    }
}

