/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.saml;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.util.ApplicationStateValidator;
import com.atlassian.plugins.authentication.impl.web.AbstractConsumerServlet;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandler;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandlerProvider;
import com.atlassian.plugins.authentication.impl.web.AuthenticationRequest;
import com.atlassian.plugins.authentication.impl.web.SessionData;
import com.atlassian.plugins.authentication.impl.web.SessionDataService;
import com.atlassian.plugins.authentication.impl.web.saml.SamlAssertionValidationService;
import com.atlassian.plugins.authentication.impl.web.saml.provider.InvalidSamlResponse;
import com.atlassian.plugins.authentication.impl.web.saml.provider.SamlProvider;
import com.atlassian.plugins.authentication.impl.web.saml.provider.SamlResponse;
import com.atlassian.plugins.authentication.impl.web.usercontext.AuthenticationFailedException;
import com.atlassian.plugins.authentication.impl.web.usercontext.PrincipalResolver;
import com.atlassian.plugins.authentication.impl.web.usercontext.rememberme.RememberMeCookieHandler;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.security.Principal;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlConsumerServlet
extends AbstractConsumerServlet {
    private static final Logger log = LoggerFactory.getLogger(SamlConsumerServlet.class);
    public static final String URL = "/plugins/servlet/samlconsumer";
    public static final String SAML_RESPONSE_PARAM = "SAMLResponse";
    public static final String RELAY_STATE_QUERY_PARAM = "RelayState";
    private final SsoConfigService ssoConfigService;
    private final SamlProvider samlProvider;
    private final SamlAssertionValidationService samlAssertionValidationService;
    private final AuthenticationHandlerProvider authenticationHandlerProvider;

    @Inject
    public SamlConsumerServlet(@ComponentImport ApplicationProperties applicationProperties, SsoConfigService ssoConfigService, PrincipalResolver principalResolver, SamlProvider samlProvider, SessionDataService sessionDataService, SamlAssertionValidationService samlAssertionValidationService, @ComponentImport AuthenticationListener authenticationListener, @ComponentImport I18nResolver i18nResolver, RememberMeCookieHandler rememberMeCookieHandler, ApplicationStateValidator applicationStateValidator, AuthenticationHandlerProvider authenticationHandlerProvider) {
        super(applicationProperties, principalResolver, sessionDataService, authenticationListener, i18nResolver, rememberMeCookieHandler, applicationStateValidator);
        this.ssoConfigService = ssoConfigService;
        this.samlProvider = samlProvider;
        this.samlAssertionValidationService = samlAssertionValidationService;
        this.authenticationHandlerProvider = authenticationHandlerProvider;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Received SAML POST payload");
        this.applicationStateValidator.checkCanProcessAuthenticationRequest();
        Optional<SessionData> sessionData = this.sessionDataService.getSessionData(request, response, request.getParameter(RELAY_STATE_QUERY_PARAM));
        Optional<AuthenticationRequest> samlRequest = sessionData.map(SessionData::getAuthenticationRequest);
        String username = null;
        try {
            SamlResponse samlResponse = this.samlProvider.extractSamlResponse(request, response, this.getServiceProviderInfo(), samlRequest.orElse(null));
            this.applicationStateValidator.checkHasAppropriateLicenseForSamlResponse(samlResponse);
            this.samlAssertionValidationService.validateAssertionId(samlResponse);
            SamlConfig samlConfig = this.ssoConfigService.getSamlConfigOrFail();
            username = this.getUsernameAttribute(samlResponse, samlConfig);
            log.debug("Extracted username {} from valid SAML request", (Object)username);
            Principal principal = this.principalResolver.resolvePrincipal(username, request);
            this.authenticationSuccess(request, response, principal, "saml.authentication.successful");
            this.refreshRememberMeCookieIfNeeded(samlConfig, request, response, samlResponse, principal);
            response.sendRedirect(this.sessionDataService.extractTargetUrlOrReturnBaseUrl(sessionData));
        }
        catch (InvalidSamlResponse e) {
            e.setTargetUrl(sessionData.flatMap(SessionData::getTargetUrl).map(URI::toString).orElse(null));
            this.authenticationListener.authenticationFailure((Authenticator.Result)new Authenticator.Result.Failure(this.i18nResolver.createMessage("saml.authentication.invalidsamlresponse", new Serializable[]{request.getRemoteAddr()})), request, response);
            throw e;
        }
        catch (AuthenticationFailedException e) {
            this.authenticationListener.authenticationFailure((Authenticator.Result)new Authenticator.Result.Failure(this.i18nResolver.createMessage("saml.authentication.authenticationfailed", new Serializable[]{username})), request, response);
            throw e;
        }
    }

    private void refreshRememberMeCookieIfNeeded(SsoConfig ssoConfig, HttpServletRequest request, HttpServletResponse response, SamlResponse samlResponse, Principal principal) {
        if (ssoConfig.isEnableRememberMe() || this.hasRememberMeFlagFromCrowd(samlResponse)) {
            this.rememberMeCookieHandler.refreshRememberMeCookie(request, response, principal);
        }
    }

    private boolean hasRememberMeFlagFromCrowd(SamlResponse samlResponse) {
        Iterable<String> attributeValues = samlResponse.getAttribute("atl.crowd.properties.remember_me");
        return attributeValues != null && StreamSupport.stream(attributeValues.spliterator(), false).anyMatch(Boolean::parseBoolean);
    }

    private String getUsernameAttribute(@Nonnull SamlResponse samlResponse, @Nonnull SamlConfig samlConfig) {
        if (StringUtils.isNotEmpty(samlConfig.getUsernameAttribute())) {
            return (String)Iterables.getOnlyElement(samlResponse.getAttribute(samlConfig.getUsernameAttribute()));
        }
        return samlResponse.getNameId();
    }

    private SamlProvider.ServiceProviderInfo getServiceProviderInfo() {
        AuthenticationHandler authenticationHandler = this.authenticationHandlerProvider.getAuthenticationHandlerUnchecked(SsoType.SAML);
        return new SamlProvider.ServiceProviderInfo(authenticationHandler.getIssuerUrl(), authenticationHandler.getConsumerServletUrl());
    }
}

