/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.oidc;

import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.config.oidc.OidcConfig;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandlerProvider;
import com.atlassian.plugins.authentication.impl.web.SessionDataService;
import com.atlassian.plugins.authentication.impl.web.oidc.OidcAuthenticationHandler;
import com.atlassian.plugins.authentication.impl.web.usercontext.AuthenticationFailedException;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitiateLoginServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(InitiateLoginServlet.class);
    public static final String URL = "/plugins/servlet/oidc/initiate-login";
    public static final String TARGET_LINK_PARAM = "target_link_uri";
    public static final String LOGIN_HINT_PARAM = "login_hint";
    public static final String ISSUER_PARAM = "iss";
    private final AuthenticationHandlerProvider authenticationHandlerProvider;
    private final SsoConfigService ssoConfigService;
    private final SessionDataService sessionDataService;

    public InitiateLoginServlet(AuthenticationHandlerProvider authenticationHandlerProvider, SsoConfigService ssoConfigService, SessionDataService sessionDataService) {
        this.authenticationHandlerProvider = authenticationHandlerProvider;
        this.ssoConfigService = ssoConfigService;
        this.sessionDataService = sessionDataService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        OidcConfig cfg = this.ssoConfigService.getOidcConfigOrFail();
        String issuerParam = req.getParameter(ISSUER_PARAM);
        if (!Objects.equals(cfg.getIssuerUrl(), issuerParam)) {
            throw new AuthenticationFailedException("Login flow initiated by unknown issuer: " + issuerParam);
        }
        log.debug("Login flow has been initiated by: {}", (Object)issuerParam);
        this.sessionDataService.requireNewSession(req);
        OidcAuthenticationHandler.setLoginHint(req, req.getParameter(LOGIN_HINT_PARAM));
        try {
            this.authenticationHandlerProvider.getAuthenticationHandlerUnchecked(cfg.getSsoType()).processAuthenticationRequest(req, resp, req.getParameter(TARGET_LINK_PARAM));
        }
        catch (IllegalArgumentException e) {
            resp.sendError(Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage());
        }
    }
}

