/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.filter.logout;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogoutFilter
implements Filter {
    protected final ApplicationProperties applicationProperties;
    protected final SsoConfigService ssoConfigService;

    public LogoutFilter(@ComponentImport ApplicationProperties applicationProperties, SsoConfigService ssoConfigService) {
        this.applicationProperties = applicationProperties;
        this.ssoConfigService = ssoConfigService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SsoConfig ssoConfig = this.ssoConfigService.getSsoConfig();
        if (ssoConfig != null && ssoConfig.isRedirectOnLogin() && this.shouldRequestBeRedirected((HttpServletRequest)request)) {
            this.redirectToSsoLogoutPage((HttpServletRequest)request, (HttpServletResponse)response);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected boolean shouldRequestBeRedirected(HttpServletRequest request) {
        return true;
    }

    protected void redirectToSsoLogoutPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.applicationProperties.getBaseUrl(UrlMode.RELATIVE) + "/plugins/servlet/sso-logout");
    }

    public void destroy() {
    }
}

