/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config.saml;

import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SamlConfig
extends SsoConfig {
    private static final String CROWD_SAML_URL_SUFFIX = "/console/secure/saml/sso.action";
    private final IdpType idpType;
    private final String ssoUrl;
    private final String ssoIssuer;
    private final String certificate;
    private final String usernameAttribute;

    private SamlConfig(boolean redirectOnLogin, boolean allowRedirectOverride, boolean includeCustomerLogins, boolean enableRememberMe, @Nonnull IdpType idpType, @Nonnull String ssoUrl, @Nonnull String ssoIssuer, @Nonnull String certificate, @Nullable String usernameAttribute) {
        super(redirectOnLogin, allowRedirectOverride, includeCustomerLogins, enableRememberMe);
        this.idpType = idpType;
        this.ssoUrl = ssoUrl;
        this.ssoIssuer = ssoIssuer;
        this.certificate = certificate;
        this.usernameAttribute = usernameAttribute;
    }

    @Override
    @Nonnull
    public SsoType getSsoType() {
        return SsoType.SAML;
    }

    @Nonnull
    public IdpType getIdpType() {
        return Optional.ofNullable(this.idpType).orElseGet(this::getInferredIdpType);
    }

    @Nonnull
    public IdpType getInferredIdpType() {
        if (StringUtils.endsWith(this.ssoUrl, CROWD_SAML_URL_SUFFIX)) {
            return IdpType.CROWD;
        }
        return IdpType.GENERIC;
    }

    public String getSsoUrl() {
        return this.ssoUrl;
    }

    public String getSsoIssuer() {
        return this.ssoIssuer;
    }

    public String getCertificate() {
        return this.certificate;
    }

    @Nullable
    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SamlConfig)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SamlConfig that = (SamlConfig)o;
        return this.idpType == that.idpType && Objects.equals(this.ssoUrl, that.ssoUrl) && Objects.equals(this.ssoIssuer, that.ssoIssuer) && Objects.equals(this.certificate, that.certificate) && Objects.equals(this.usernameAttribute, that.usernameAttribute);
    }

    public static Optional<SamlConfig> from(SsoConfig config) {
        return config instanceof SamlConfig ? Optional.of((SamlConfig)config) : Optional.empty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.idpType, this.ssoUrl, this.ssoIssuer, this.certificate, this.usernameAttribute});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@Nonnull SamlConfig samlConfig) {
        return new Builder(samlConfig);
    }

    public static class Builder
    extends SsoConfig.Builder<Builder> {
        private IdpType idpType = IdpType.GENERIC;
        private String ssoUrl;
        private String ssoIssuer;
        private String certificate;
        private String usernameAttribute;

        private Builder() {
        }

        private Builder(@Nonnull SamlConfig samlConfig) {
            super(samlConfig);
            this.idpType = samlConfig.getIdpType();
            this.ssoUrl = samlConfig.getSsoUrl();
            this.ssoIssuer = samlConfig.getSsoIssuer();
            this.certificate = samlConfig.getCertificate();
            this.usernameAttribute = samlConfig.getUsernameAttribute();
        }

        public Builder setIdpType(IdpType idpType) {
            this.idpType = idpType;
            return this;
        }

        public Builder setSsoUrl(String ssoUrl) {
            this.ssoUrl = ssoUrl;
            return this;
        }

        public Builder setSsoIssuer(String ssoIssuer) {
            this.ssoIssuer = ssoIssuer;
            return this;
        }

        public Builder setCertificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public Builder setUsernameAttribute(String usernameAttribute) {
            this.usernameAttribute = usernameAttribute;
            return this;
        }

        public Builder setCrowdBaseUrl(@Nonnull String crowdBaseUrl) {
            String strippedCrowdBaseUrl = StringUtils.removeEnd(crowdBaseUrl, SamlConfig.CROWD_SAML_URL_SUFFIX);
            return this.setIdpType(IdpType.CROWD).setSsoUrl(StringUtils.stripEnd(strippedCrowdBaseUrl, "/") + SamlConfig.CROWD_SAML_URL_SUFFIX).setSsoIssuer(strippedCrowdBaseUrl);
        }

        @Override
        @Nonnull
        public SamlConfig build() {
            return new SamlConfig(this.redirectOnLogin, this.allowRedirectOverride, this.includeCustomerLogins, this.enableRememberMe, this.idpType, this.ssoUrl, this.ssoIssuer, this.certificate, this.usernameAttribute);
        }
    }

    public static enum IdpType {
        GENERIC,
        CROWD;


        @Nonnull
        public static Optional<IdpType> fromName(@Nullable String value) {
            return Arrays.stream(IdpType.values()).filter(type -> Objects.equals(type.name(), value)).findFirst();
        }
    }
}

